/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.Page;
import com.avaje.ebean.PagingList;
import com.avaje.ebeaninternal.api.Monitor;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.query.LimitOffsetList;
import com.avaje.ebeaninternal.server.query.LimitOffsetPage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import javax.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitOffsetPagingQuery<T>
implements PagingList<T> {
    private transient EbeanServer server;
    private final SpiQuery<T> query;
    private final List<LimitOffsetPage<T>> pages = new ArrayList<LimitOffsetPage<T>>();
    private final Monitor monitor = new Monitor();
    private final int pageSize;
    private boolean fetchAhead = true;
    private Future<Integer> futureRowCount;

    public LimitOffsetPagingQuery(EbeanServer server, SpiQuery<T> query, int pageSize) {
        this.query = query;
        this.pageSize = pageSize;
        this.server = server;
    }

    public EbeanServer getServer() {
        return this.server;
    }

    public void setServer(EbeanServer server) {
        this.server = server;
    }

    public SpiQuery<T> getSpiQuery() {
        return this.query;
    }

    @Override
    public PagingList<T> setFetchAhead(boolean fetchAhead) {
        this.fetchAhead = fetchAhead;
        return this;
    }

    @Override
    public List<T> getAsList() {
        return new LimitOffsetList(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Integer> getFutureRowCount() {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            if (this.futureRowCount == null) {
                this.futureRowCount = this.server.findFutureRowCount(this.query, null);
            }
            return this.futureRowCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LimitOffsetPage<T> internalGetPage(int i) {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            int ps = this.pages.size();
            if (ps <= i) {
                for (int j = ps; j <= i; ++j) {
                    LimitOffsetPage p = new LimitOffsetPage(j, this);
                    this.pages.add(p);
                }
            }
            return this.pages.get(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchAheadIfRequired(int pageIndex) {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            if (this.fetchAhead) {
                LimitOffsetPage<T> nextPage = this.internalGetPage(pageIndex + 1);
                nextPage.getFutureList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        Monitor monitor = this.monitor;
        synchronized (monitor) {
            this.futureRowCount = null;
            this.pages.clear();
        }
    }

    @Override
    public Page<T> getPage(int i) {
        return this.internalGetPage(i);
    }

    protected boolean hasNext(int position) {
        return position < this.getTotalRowCount();
    }

    protected T get(int rowIndex) {
        int pg = rowIndex / this.pageSize;
        int offset = rowIndex % this.pageSize;
        Page<T> page = this.getPage(pg);
        return page.getList().get(offset);
    }

    @Override
    public int getTotalPageCount() {
        int rowCount = this.getTotalRowCount();
        if (rowCount == 0) {
            return 0;
        }
        return (rowCount - 1) / this.pageSize + 1;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getTotalRowCount() {
        try {
            return this.getFutureRowCount().get();
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

