/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.reflections.ReflectionsException;
import org.reflections.util.ClasspathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionUtils {
    public static final List<String> primitiveNames = Lists.newArrayList((Object[])new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "void"});
    public static final List<Class> primitiveTypes = Lists.newArrayList((Object[])new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE});
    public static final List<String> primitiveDescriptors = Lists.newArrayList((Object[])new String[]{"Z", "C", "B", "S", "I", "J", "F", "D", "V"});

    public static Set<Class<?>> getAllSuperTypes(Class<?> type, Predicate<? super Class<?>> predicate) {
        HashSet result = Sets.newHashSet();
        if (type != null) {
            result.add(type);
            result.addAll(ReflectionUtils.getAllSuperTypes(type.getSuperclass(), Predicates.alwaysTrue()));
            for (Class<?> inter : type.getInterfaces()) {
                result.addAll(ReflectionUtils.getAllSuperTypes(inter, Predicates.alwaysTrue()));
            }
        }
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)result, predicate));
    }

    public static Set<Class<?>> getAllSuperTypes(Iterable<Class<?>> types, Predicate<? super Class<?>> predicate) {
        HashSet result = Sets.newHashSet();
        for (Class<?> type : types) {
            result.addAll(ReflectionUtils.getAllSuperTypes(type, predicate));
        }
        return result;
    }

    public static Set<Field> getAllFields(Class<?> type, Predicate<? super Field> predicate) {
        HashSet result = Sets.newHashSet();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type, Predicates.alwaysTrue())) {
            Collections.addAll(result, t.getDeclaredFields());
        }
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)result, predicate));
    }

    public static Set<Field> getAllFields(Iterable<Class<?>> types, Predicate<? super Field> predicate) {
        HashSet result = Sets.newHashSet();
        for (Class<?> type : types) {
            result.addAll(ReflectionUtils.getAllFields(type, predicate));
        }
        return result;
    }

    public static Set<Method> getAllMethods(Class<?> type, Predicate<? super Method> predicate) {
        HashSet result = Sets.newHashSet();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type, Predicates.alwaysTrue())) {
            Collections.addAll(result, t.isInterface() ? t.getMethods() : t.getDeclaredMethods());
        }
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)result, predicate));
    }

    public static Set<Method> getAllMethods(Iterable<Class<?>> types, Predicate<? super Method> predicate) {
        HashSet result = Sets.newHashSet();
        for (Class<?> type : types) {
            result.addAll(ReflectionUtils.getAllMethods(type, predicate));
        }
        return Sets.newHashSet((Iterable)result);
    }

    public static <T extends AnnotatedElement> Set<T> getAll(Iterable<T> elements, Predicate<? super T> predicate) {
        return Sets.newHashSet((Iterable)Iterables.filter(elements, predicate));
    }

    public static <T extends Member> Predicate<T> withName(final String name) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                return input != null && input.getName().equals(name);
            }
        };
    }

    public static <T extends Member> Predicate<T> withPrefix(final String prefix) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                return input != null && input.getName().startsWith(prefix);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(final Class<? extends Annotation> annotation) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                return input != null && input.isAnnotationPresent(annotation);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(final Annotation annotation) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                return input != null && input.isAnnotationPresent(annotation.annotationType()) && ReflectionUtils.areAnnotationMembersMatching(input.getAnnotation(annotation.annotationType()), annotation);
            }
        };
    }

    public static Predicate<Method> withParameters(final Class ... types) {
        return new Predicate<Method>(){

            public boolean apply(@Nullable Method input) {
                return input != null && Arrays.equals(input.getParameterTypes(), types);
            }
        };
    }

    public static Predicate<Method> withParametersAssignableFrom(final Class ... types) {
        return new Predicate<Method>(){

            public boolean apply(@Nullable Method input) {
                Class<?>[] parameterTypes;
                if (input != null && (parameterTypes = input.getParameterTypes()).length == types.length) {
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (parameterTypes[i].isAssignableFrom(types[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Method> withParametersCount(final int count) {
        return new Predicate<Method>(){

            public boolean apply(@Nullable Method input) {
                return input != null && input.getParameterTypes().length == count;
            }
        };
    }

    public static <T> Predicate<Field> withType(final Class<T> type) {
        return new Predicate<Field>(){

            public boolean apply(@Nullable Field input) {
                return input != null && input.getType().equals(type);
            }
        };
    }

    public static <T> Predicate<Field> withTypeAssignableFrom(final Class<T> type) {
        return new Predicate<Field>(){

            public boolean apply(@Nullable Field input) {
                return input != null && input.getType().isAssignableFrom(type);
            }
        };
    }

    public static <T> Predicate<Method> withReturnType(final Class<T> type) {
        return new Predicate<Method>(){

            public boolean apply(@Nullable Method input) {
                return input != null && input.getReturnType().equals(type);
            }
        };
    }

    public static <T> Predicate<Method> withReturnTypeAssignableFrom(final Class<T> type) {
        return new Predicate<Method>(){

            public boolean apply(@Nullable Method input) {
                return input != null && input.getReturnType().isAssignableFrom(type);
            }
        };
    }

    public static <T extends Member> Predicate<T> withModifier(final int mod) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                return input != null && (input.getModifiers() & mod) != 0;
            }
        };
    }

    public static boolean areAnnotationMembersMatching(Annotation annotation1, Annotation annotation2) {
        if (annotation2 != null && annotation1.annotationType() == annotation2.annotationType()) {
            for (Method method : annotation1.annotationType().getDeclaredMethods()) {
                try {
                    if (method.invoke((Object)annotation1, new Object[0]).equals(method.invoke((Object)annotation2, new Object[0]))) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new ReflectionsException(String.format("could not invoke method %s on annotation %s", method.getName(), annotation1.annotationType()), e);
                }
            }
            return true;
        }
        return false;
    }

    public static <T extends AnnotatedElement> Set<T> getMatchingAnnotations(Set<T> annotatedElements, Annotation annotation) {
        HashSet result = Sets.newHashSet();
        for (AnnotatedElement annotatedElement : annotatedElements) {
            Annotation annotation1 = annotatedElement.getAnnotation(annotation.annotationType());
            if (!ReflectionUtils.areAnnotationMembersMatching(annotation, annotation1)) continue;
            result.add(annotatedElement);
        }
        return result;
    }

    public static Class<?> forName(String typeName, ClassLoader ... classLoaders) {
        String type;
        if (primitiveNames.contains(typeName)) {
            return primitiveTypes.get(primitiveNames.indexOf(typeName));
        }
        if (typeName.contains("[")) {
            int i = typeName.indexOf("[");
            type = typeName.substring(0, i);
            String array = typeName.substring(i).replace("]", "");
            type = primitiveNames.contains(type) ? primitiveDescriptors.get(primitiveNames.indexOf(type)) : "L" + type + ";";
            type = array + type;
        } else {
            type = typeName;
        }
        for (ClassLoader classLoader : ClasspathHelper.classLoaders(classLoaders)) {
            try {
                return Class.forName(type, false, classLoader);
            }
            catch (ClassNotFoundException e) {
            }
        }
        return null;
    }

    public static <T> List<Class<? extends T>> forNames(Iterable<String> classes, ClassLoader ... classLoaders) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (String className : classes) {
            result.add(ReflectionUtils.forName(className, classLoaders));
        }
        return result;
    }

    public static List<String> names(Iterable<Class<?>> types) {
        ArrayList result = Lists.newArrayList();
        for (Class<?> type : types) {
            result.add(type.getName());
        }
        return result;
    }
}

