/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.jboss.netty.channel.socket.nio.NioAcceptedSocketChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import org.jboss.netty.channel.socket.nio.NioProviderMetadata;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.SelectorUtil;
import org.jboss.netty.channel.socket.nio.SocketReceiveBufferPool;
import org.jboss.netty.channel.socket.nio.SocketSendBufferPool;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.DeadLockProofWorker;
import org.jboss.netty.util.internal.QueueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioWorker
implements Runnable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioWorker.class);
    private static final int CONSTRAINT_LEVEL = NioProviderMetadata.CONSTRAINT_LEVEL;
    static final int CLEANUP_INTERVAL = 256;
    private final int bossId;
    private final int id;
    private final Executor executor;
    private boolean started;
    private volatile Thread thread;
    volatile Selector selector;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private final ReadWriteLock selectorGuard = new ReentrantReadWriteLock();
    private final Object startStopLock = new Object();
    private final Queue<Runnable> registerTaskQueue = QueueFactory.createQueue(Runnable.class);
    private final Queue<Runnable> writeTaskQueue = QueueFactory.createQueue(Runnable.class);
    private volatile int cancelledKeys;
    private final SocketReceiveBufferPool recvBufferPool = new SocketReceiveBufferPool();
    private final SocketSendBufferPool sendBufferPool = new SocketSendBufferPool();

    NioWorker(int bossId, int id, Executor executor) {
        this.bossId = bossId;
        this.id = id;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(NioSocketChannel channel, ChannelFuture future) {
        Selector selector;
        boolean server = !(channel instanceof NioClientSocketChannel);
        RegisterTask registerTask = new RegisterTask(channel, future, server);
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                try {
                    this.selector = selector = Selector.open();
                }
                catch (Throwable t) {
                    throw new ChannelException("Failed to create a selector.", t);
                }
                String threadName = (server ? "New I/O server worker #" : "New I/O client worker #") + this.bossId + '-' + this.id;
                boolean success = false;
                try {
                    DeadLockProofWorker.start(this.executor, new ThreadRenamingRunnable(this, threadName));
                    success = true;
                }
                finally {
                    if (!success) {
                        try {
                            selector.close();
                        }
                        catch (Throwable t) {
                            logger.warn("Failed to close a selector.", t);
                        }
                        selector = null;
                        this.selector = null;
                    }
                }
            }
            selector = this.selector;
            assert (selector != null && selector.isOpen());
            this.started = true;
            boolean offered = this.registerTaskQueue.offer(registerTask);
            assert (offered);
        }
        if (this.wakenUp.compareAndSet(false, true)) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        boolean shutdown = false;
        Selector selector = this.selector;
        while (true) {
            this.wakenUp.set(false);
            if (CONSTRAINT_LEVEL != 0) {
                this.selectorGuard.writeLock().lock();
                this.selectorGuard.writeLock().unlock();
            }
            try {
                SelectorUtil.select(selector);
                if (this.wakenUp.get()) {
                    selector.wakeup();
                }
                this.cancelledKeys = 0;
                this.processRegisterTaskQueue();
                this.processWriteTaskQueue();
                this.processSelectedKeys(selector.selectedKeys());
                if (selector.keys().isEmpty()) {
                    if (shutdown || this.executor instanceof ExecutorService && ((ExecutorService)this.executor).isShutdown()) {
                        Object object = this.startStopLock;
                        synchronized (object) {
                            if (this.registerTaskQueue.isEmpty() && selector.keys().isEmpty()) {
                                this.started = false;
                                try {
                                    selector.close();
                                }
                                catch (IOException e) {
                                    logger.warn("Failed to close a selector.", e);
                                }
                                finally {
                                    this.selector = null;
                                }
                                break;
                            }
                            shutdown = false;
                            continue;
                        }
                    }
                    shutdown = true;
                    continue;
                }
                shutdown = false;
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception in the selector loop.", t);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private void processRegisterTaskQueue() throws IOException {
        Runnable task;
        while ((task = this.registerTaskQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processWriteTaskQueue() throws IOException {
        Runnable task;
        while ((task = this.writeTaskQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processSelectedKeys(Set<SelectionKey> selectedKeys) throws IOException {
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            try {
                int readyOps = k.readyOps();
                if (((readyOps & 1) != 0 || readyOps == 0) && !this.read(k)) continue;
                if ((readyOps & 4) != 0) {
                    this.writeFromSelectorLoop(k);
                }
            }
            catch (CancelledKeyException e) {
                this.close(k);
            }
            if (!this.cleanUpCancelledKeys()) continue;
            break;
        }
    }

    private boolean cleanUpCancelledKeys() throws IOException {
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.selector.selectNow();
            return true;
        }
        return false;
    }

    private boolean read(SelectionKey k) {
        SocketChannel ch = (SocketChannel)k.channel();
        NioSocketChannel channel = (NioSocketChannel)k.attachment();
        ReceiveBufferSizePredictor predictor = channel.getConfig().getReceiveBufferSizePredictor();
        int predictedRecvBufSize = predictor.nextReceiveBufferSize();
        int ret = 0;
        int readBytes = 0;
        boolean failure = true;
        ByteBuffer bb = this.recvBufferPool.acquire(predictedRecvBufSize);
        try {
            while ((ret = ch.read(bb)) > 0) {
                readBytes += ret;
                if (bb.hasRemaining()) continue;
            }
            failure = false;
        }
        catch (ClosedChannelException e) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (readBytes > 0) {
            bb.flip();
            ChannelBufferFactory bufferFactory = channel.getConfig().getBufferFactory();
            ChannelBuffer buffer = bufferFactory.getBuffer(readBytes);
            buffer.setBytes(0, bb);
            buffer.writerIndex(readBytes);
            this.recvBufferPool.release(bb);
            predictor.previousReceiveBufferSize(readBytes);
            Channels.fireMessageReceived(channel, (Object)buffer);
        } else {
            this.recvBufferPool.release(bb);
        }
        if (ret < 0 || failure) {
            k.cancel();
            this.close(channel, Channels.succeededFuture(channel));
            return false;
        }
        return true;
    }

    private void close(SelectionKey k) {
        NioSocketChannel ch = (NioSocketChannel)k.attachment();
        this.close(ch, Channels.succeededFuture(ch));
    }

    void writeFromUserCode(NioSocketChannel channel) {
        if (!channel.isConnected()) {
            this.cleanUpWriteBuffer(channel);
            return;
        }
        if (this.scheduleWriteIfNecessary(channel)) {
            return;
        }
        if (channel.writeSuspended) {
            return;
        }
        if (channel.inWriteNowLoop) {
            return;
        }
        this.write0(channel);
    }

    void writeFromTaskLoop(NioSocketChannel ch) {
        if (!ch.writeSuspended) {
            this.write0(ch);
        }
    }

    void writeFromSelectorLoop(SelectionKey k) {
        NioSocketChannel ch = (NioSocketChannel)k.attachment();
        ch.writeSuspended = false;
        this.write0(ch);
    }

    private boolean scheduleWriteIfNecessary(NioSocketChannel channel) {
        Thread workerThread;
        Thread currentThread = Thread.currentThread();
        if (currentThread != (workerThread = this.thread)) {
            Selector workerSelector;
            if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
                boolean offered = this.writeTaskQueue.offer(channel.writeTask);
                assert (offered);
            }
            if ((!(channel instanceof NioAcceptedSocketChannel) || ((NioAcceptedSocketChannel)channel).bossThread != currentThread) && (workerSelector = this.selector) != null && this.wakenUp.compareAndSet(false, true)) {
                workerSelector.wakeup();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write0(NioSocketChannel channel) {
        boolean open = true;
        boolean addOpWrite = false;
        boolean removeOpWrite = false;
        long writtenBytes = 0L;
        SocketSendBufferPool sendBufferPool = this.sendBufferPool;
        SocketChannel ch = channel.socket;
        Queue<MessageEvent> writeBuffer = channel.writeBuffer;
        int writeSpinCount = channel.getConfig().getWriteSpinCount();
        Object object = channel.writeLock;
        synchronized (object) {
            channel.inWriteNowLoop = true;
            while (true) {
                SocketSendBufferPool.SendBuffer buf;
                MessageEvent evt;
                if ((evt = channel.currentWriteEvent) == null) {
                    channel.currentWriteEvent = evt = writeBuffer.poll();
                    if (evt == null) {
                        removeOpWrite = true;
                        channel.writeSuspended = false;
                        break;
                    }
                    channel.currentWriteBuffer = buf = sendBufferPool.acquire(evt.getMessage());
                } else {
                    buf = channel.currentWriteBuffer;
                }
                ChannelFuture future = evt.getFuture();
                try {
                    long localWrittenBytes = 0L;
                    for (int i = writeSpinCount; i > 0; --i) {
                        localWrittenBytes = buf.transferTo(ch);
                        if (localWrittenBytes != 0L) {
                            writtenBytes += localWrittenBytes;
                            break;
                        }
                        if (buf.finished()) break;
                    }
                    if (buf.finished()) {
                        buf.release();
                        channel.currentWriteEvent = null;
                        channel.currentWriteBuffer = null;
                        evt = null;
                        buf = null;
                        future.setSuccess();
                        continue;
                    }
                    addOpWrite = true;
                    channel.writeSuspended = true;
                    if (localWrittenBytes <= 0L) break;
                    future.setProgress(localWrittenBytes, buf.writtenBytes(), buf.totalBytes());
                }
                catch (AsynchronousCloseException e) {
                    continue;
                }
                catch (Throwable t) {
                    buf.release();
                    channel.currentWriteEvent = null;
                    channel.currentWriteBuffer = null;
                    buf = null;
                    evt = null;
                    future.setFailure(t);
                    Channels.fireExceptionCaught(channel, t);
                    if (!(t instanceof IOException)) continue;
                    open = false;
                    this.close(channel, Channels.succeededFuture(channel));
                    continue;
                }
                break;
            }
            channel.inWriteNowLoop = false;
            if (open) {
                if (addOpWrite) {
                    this.setOpWrite(channel);
                } else if (removeOpWrite) {
                    this.clearOpWrite(channel);
                }
            }
        }
        Channels.fireWriteComplete(channel, writtenBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOpWrite(NioSocketChannel channel) {
        Selector selector = this.selector;
        SelectionKey key = channel.socket.keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            this.close(key);
            return;
        }
        Object object = channel.interestOpsLock;
        synchronized (object) {
            int interestOps = channel.getRawInterestOps();
            if ((interestOps & 4) == 0) {
                key.interestOps(interestOps |= 4);
                channel.setRawInterestOpsNow(interestOps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOpWrite(NioSocketChannel channel) {
        Selector selector = this.selector;
        SelectionKey key = channel.socket.keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            this.close(key);
            return;
        }
        Object object = channel.interestOpsLock;
        synchronized (object) {
            int interestOps = channel.getRawInterestOps();
            if ((interestOps & 4) != 0) {
                key.interestOps(interestOps &= 0xFFFFFFFB);
                channel.setRawInterestOpsNow(interestOps);
            }
        }
    }

    void close(NioSocketChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.socket.close();
            ++this.cancelledKeys;
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Channels.fireChannelDisconnected(channel);
                }
                if (bound) {
                    Channels.fireChannelUnbound(channel);
                }
                this.cleanUpWriteBuffer(channel);
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpWriteBuffer(NioSocketChannel channel) {
        Exception cause = null;
        boolean fireExceptionCaught = false;
        Object object = channel.writeLock;
        synchronized (object) {
            Queue<MessageEvent> writeBuffer;
            MessageEvent evt = channel.currentWriteEvent;
            if (evt != null) {
                cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                ChannelFuture future = evt.getFuture();
                channel.currentWriteBuffer.release();
                channel.currentWriteBuffer = null;
                channel.currentWriteEvent = null;
                evt = null;
                future.setFailure(cause);
                fireExceptionCaught = true;
            }
            if (!(writeBuffer = channel.writeBuffer).isEmpty()) {
                if (cause == null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                }
                while ((evt = writeBuffer.poll()) != null) {
                    evt.getFuture().setFailure(cause);
                    fireExceptionCaught = true;
                }
            }
        }
        if (fireExceptionCaught) {
            Channels.fireExceptionCaught(channel, (Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterestOps(NioSocketChannel channel, ChannelFuture future, int interestOps) {
        boolean changed = false;
        try {
            Object object = channel.interestOpsLock;
            synchronized (object) {
                Selector selector = this.selector;
                SelectionKey key = channel.socket.keyFor(selector);
                if (key == null || selector == null) {
                    channel.setRawInterestOpsNow(interestOps);
                    return;
                }
                interestOps &= 0xFFFFFFFB;
                interestOps |= channel.getRawInterestOps() & 4;
                switch (CONSTRAINT_LEVEL) {
                    case 0: {
                        if (channel.getRawInterestOps() == interestOps) break;
                        key.interestOps(interestOps);
                        if (Thread.currentThread() != this.thread && this.wakenUp.compareAndSet(false, true)) {
                            selector.wakeup();
                        }
                        changed = true;
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (channel.getRawInterestOps() == interestOps) break;
                        if (Thread.currentThread() == this.thread) {
                            key.interestOps(interestOps);
                            changed = true;
                            break;
                        }
                        this.selectorGuard.readLock().lock();
                        try {
                            if (this.wakenUp.compareAndSet(false, true)) {
                                selector.wakeup();
                            }
                            key.interestOps(interestOps);
                            changed = true;
                            break;
                        }
                        finally {
                            this.selectorGuard.readLock().unlock();
                        }
                    }
                    default: {
                        throw new Error();
                    }
                }
                if (changed) {
                    channel.setRawInterestOpsNow(interestOps);
                }
            }
            future.setSuccess();
            if (changed) {
                Channels.fireChannelInterestChanged(channel);
            }
        }
        catch (CancelledKeyException e) {
            ClosedChannelException cce = new ClosedChannelException();
            future.setFailure(cce);
            Channels.fireExceptionCaught(channel, (Throwable)cce);
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private final class RegisterTask
    implements Runnable {
        private final NioSocketChannel channel;
        private final ChannelFuture future;
        private final boolean server;

        RegisterTask(NioSocketChannel channel, ChannelFuture future, boolean server) {
            this.channel = channel;
            this.future = future;
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InetSocketAddress remoteAddress;
            InetSocketAddress localAddress;
            block11: {
                localAddress = this.channel.getLocalAddress();
                remoteAddress = this.channel.getRemoteAddress();
                if (localAddress == null || remoteAddress == null) {
                    if (this.future != null) {
                        this.future.setFailure(new ClosedChannelException());
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    return;
                }
                try {
                    if (this.server) {
                        this.channel.socket.configureBlocking(false);
                    }
                    Object object = this.channel.interestOpsLock;
                    synchronized (object) {
                        this.channel.socket.register(NioWorker.this.selector, this.channel.getRawInterestOps(), this.channel);
                    }
                    if (this.future != null) {
                        this.channel.setConnected();
                        this.future.setSuccess();
                    }
                }
                catch (IOException e) {
                    if (this.future != null) {
                        this.future.setFailure(e);
                    }
                    NioWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    if (e instanceof ClosedChannelException) break block11;
                    throw new ChannelException("Failed to register a socket to the selector.", e);
                }
            }
            if (this.server || !((NioClientSocketChannel)this.channel).boundManually) {
                Channels.fireChannelBound(this.channel, (SocketAddress)localAddress);
            }
            Channels.fireChannelConnected(this.channel, (SocketAddress)remoteAddress);
        }
    }
}

