/*
 * Decompiled with CFR 0.152.
 */
package scalax.io.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scalax.io.CloseAction$Noop$;
import scalax.io.DefaultResourceContext$;
import scalax.io.OpenOption;
import scalax.io.StandardOpenOption$;
import scalax.io.extractor.FileChannelExtractor$;
import scalax.io.extractor.ReadableByteChannelExtractor$;
import scalax.io.extractor.WritableByteChannelExtractor$;
import scalax.io.managed.OutputStreamResource;
import scalax.io.nio.SeekableFileChannel;
import scalax.io.support.DeletingFileOutputStream;
import scalax.io.support.FileUtils$$anonfun$scalax$io$support$FileUtils$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils$
implements ScalaObject {
    public static final FileUtils$ MODULE$;

    static {
        new FileUtils$();
    }

    public OutputStreamResource<FileOutputStream> openOutputStream(File jfile$1, Seq<OpenOption> openOptions$1) {
        Serializable serializable = new Serializable(jfile$1, openOptions$1){
            public static final long serialVersionUID;
            public final File jfile$1;
            public final Seq openOptions$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final FileOutputStream apply() {
                Tuple2<Object, Seq<OpenOption>> tuple2 = FileUtils$.MODULE$.scalax$io$support$FileUtils$$preOpen(this.jfile$1, (Seq<OpenOption>)this.openOptions$1, true);
                if (tuple2 != null) {
                    Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                    boolean append2 = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
                    Seq options = (Seq)tuple22._2();
                    return options.contains((Object)StandardOpenOption$.MODULE$.DeleteOnClose()) ? new DeletingFileOutputStream(this.jfile$1, append2) : new FileOutputStream(this.jfile$1, append2);
                }
                throw new MatchError(tuple2);
            }
            {
                this.jfile$1 = file;
                this.openOptions$1 = seq;
            }
        };
        return new OutputStreamResource<Object>((Function0<Object>)serializable, DefaultResourceContext$.MODULE$, CloseAction$Noop$.MODULE$);
    }

    public SeekableFileChannel openChannel(RandomAccessFile raf, Seq<OpenOption> openOptions) {
        if (openOptions.contains((Object)StandardOpenOption$.MODULE$.DeleteOnClose())) {
            throw new UnsupportedOperationException("DeleteOnClose is not supported on FileChannels pre Java 7 implementations.");
        }
        if (openOptions.contains((Object)StandardOpenOption$.MODULE$.Truncate()) && openOptions.exists((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(OpenOption opt) {
                OpenOption openOption = opt;
                Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
                if (openOption == null) {
                    if (val == null) return true;
                } else if (openOption.equals(val)) return true;
                OpenOption openOption2 = opt;
                Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
                if (openOption2 != null) {
                    if (!openOption2.equals(val2)) return false;
                    return true;
                }
                if (val2 == null) return true;
                return false;
            }
        })) {
            raf.setLength(0L);
        }
        if (openOptions.contains((Object)StandardOpenOption$.MODULE$.Append())) {
            raf.seek(raf.length());
        }
        return new SeekableFileChannel(raf.getChannel());
    }

    public SeekableFileChannel openChannel(File jfile, Seq<OpenOption> openOptions) {
        Tuple2<Object, Seq<OpenOption>> tuple2 = this.scalax$io$support$FileUtils$$preOpen(jfile, openOptions, false);
        if (tuple2 != null) {
            Seq options = (Seq)tuple2._2();
            if (options.contains((Object)StandardOpenOption$.MODULE$.DeleteOnClose())) {
                throw new UnsupportedOperationException("DeleteOnClose is not supported on FileChannels pre Java 7 implementations.");
            }
            return this.openChannel(this.randomAccessFile(jfile, (Seq<OpenOption>)options), (Seq<OpenOption>)options);
        }
        throw new MatchError(tuple2);
    }

    public final Tuple2<Object, Seq<OpenOption>> scalax$io$support$FileUtils$$preOpen(File jfile$2, Seq<OpenOption> openOptions, boolean processTruncate$1) {
        Seq<OpenOption> options$1 = openOptions.isEmpty() ? StandardOpenOption$.MODULE$.WriteTruncate() : openOptions;
        BooleanRef append$1 = new BooleanRef(false);
        options$1.foreach((Function1)new Serializable(jfile$2, processTruncate$1, options$1, append$1){
            public static final long serialVersionUID;
            public final File jfile$2;
            private final boolean processTruncate$1;
            private final Seq options$1;
            public final BooleanRef append$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(OpenOption openOption) {
                Object object;
                OpenOption openOption2 = openOption;
                Enumeration.Val val = StandardOpenOption$.MODULE$.Append();
                OpenOption openOption3 = openOption2;
                if (!(val != null ? !val.equals(openOption3) : openOption3 != null)) {
                    this.append$1.elem = true;
                    object = BoxedUnit.UNIT;
                    return object;
                } else {
                    Enumeration.Val val2 = StandardOpenOption$.MODULE$.Create();
                    OpenOption openOption4 = openOption2;
                    if (!(val2 != null ? !val2.equals(openOption4) : openOption4 != null) && this.gd1$1()) {
                        object = BoxesRunTime.boxToBoolean((boolean)this.jfile$2.createNewFile());
                        return object;
                    } else {
                        Enumeration.Val val3 = StandardOpenOption$.MODULE$.CreateFull();
                        OpenOption openOption5 = openOption2;
                        if (!(val3 != null ? !val3.equals(openOption5) : openOption5 != null) && this.gd2$1()) {
                            void $inlThis3;
                            void $inlThis1;
                            Option option = Option$.MODULE$.apply((Object)this.jfile$2.getParentFile());
                            void parent = !option.isEmpty() ? $inlThis1 : Option$.MODULE$.apply((Object)this.jfile$2.getAbsoluteFile().getParentFile());
                            Serializable serializable = new Serializable(this){
                                public static final long serialVersionUID;
                                public final anonfun$scalax$io$support$FileUtils$$preOpen$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Nothing$ apply() {
                                    throw new IOException(new StringBuilder().append((Object)"unable to get parent file of").append((Object)this.$outer.jfile$2).toString());
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            };
                            void var7_9 = parent;
                            if (var7_9.isEmpty()) throw serializable.apply();
                            ((File)$inlThis3.get()).mkdirs();
                            object = BoxesRunTime.boxToBoolean((boolean)this.jfile$2.createNewFile());
                            return object;
                        } else {
                            Enumeration.Val val4 = StandardOpenOption$.MODULE$.CreateNew();
                            OpenOption openOption6 = openOption2;
                            if (!(val4 != null ? !val4.equals(openOption6) : openOption6 != null)) {
                                if (this.jfile$2.exists()) {
                                    throw new IOException(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd((Object)this.jfile$2).$plus(" already exists, openOption '")).append((Object)StandardOpenOption$.MODULE$.CreateNew()).append((Object)"' cannot be used with an existing file").toString());
                                }
                                object = BoxedUnit.UNIT;
                                return object;
                            } else {
                                Enumeration.Val val5 = StandardOpenOption$.MODULE$.Truncate();
                                OpenOption openOption7 = openOption2;
                                if (!(val5 != null ? !val5.equals(openOption7) : openOption7 != null) && this.gd3$1()) {
                                    new FileOutputStream(this.jfile$2).close();
                                    object = BoxedUnit.UNIT;
                                    return object;
                                } else {
                                    object = BoxedUnit.UNIT;
                                }
                            }
                        }
                    }
                }
                return object;
            }

            private final boolean gd1$1() {
                return !this.jfile$2.exists();
            }

            private final boolean gd2$1() {
                return !this.jfile$2.exists();
            }

            private final boolean gd3$1() {
                return this.processTruncate$1 && this.options$1.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(OpenOption opt) {
                        OpenOption openOption = opt;
                        Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
                        if (openOption == null) {
                            if (val == null) return true;
                        } else if (openOption.equals(val)) return true;
                        OpenOption openOption2 = opt;
                        Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
                        if (openOption2 != null) {
                            if (!openOption2.equals(val2)) return false;
                            return true;
                        }
                        if (val2 == null) return true;
                        return false;
                    }
                }) && this.jfile$2.length() > 0L;
            }
            {
                this.jfile$2 = file;
                this.processTruncate$1 = bl;
                this.options$1 = seq;
                this.append$1 = booleanRef;
            }
        });
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)append$1.elem), options$1);
    }

    private RandomAccessFile randomAccessFile(File jfile, Seq<OpenOption> openOptions) {
        Seq unsortedChars = (Seq)openOptions.collect(new PartialFunction(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final char apply(OpenOption openOption) {
                OpenOption openOption2;
                block7: {
                    int n;
                    block3: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        openOption2 = openOption;
                                        Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
                                        OpenOption openOption3 = openOption2;
                                        if (val != null ? !val.equals(openOption3) : openOption3 != null) break block2;
                                        n = 119;
                                        break block3;
                                    }
                                    Enumeration.Val val = StandardOpenOption$.MODULE$.Append();
                                    OpenOption openOption4 = openOption2;
                                    if (val != null ? !val.equals(openOption4) : openOption4 != null) break block4;
                                    n = 119;
                                    break block3;
                                }
                                Enumeration.Val val = StandardOpenOption$.MODULE$.Read();
                                OpenOption openOption5 = openOption2;
                                if (val != null ? !val.equals(openOption5) : openOption5 != null) break block5;
                                n = 114;
                                break block3;
                            }
                            Enumeration.Val val = StandardOpenOption$.MODULE$.Sync();
                            OpenOption openOption6 = openOption2;
                            if (val != null ? !val.equals(openOption6) : openOption6 != null) break block6;
                            n = 115;
                            break block3;
                        }
                        Enumeration.Val val = StandardOpenOption$.MODULE$.DSync();
                        OpenOption openOption7 = openOption2;
                        if (val != null ? !val.equals(openOption7) : openOption7 != null) break block7;
                        n = 100;
                    }
                    return (char)n;
                }
                throw new MatchError((Object)openOption2);
            }

            public final boolean isDefinedAt(OpenOption openOption) {
                boolean bl;
                OpenOption openOption2 = openOption;
                Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
                OpenOption openOption3 = openOption2;
                if (!(val != null ? !val.equals(openOption3) : openOption3 != null)) {
                    bl = true;
                } else {
                    Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
                    OpenOption openOption4 = openOption2;
                    if (!(val2 != null ? !val2.equals(openOption4) : openOption4 != null)) {
                        bl = true;
                    } else {
                        Enumeration.Val val3 = StandardOpenOption$.MODULE$.Read();
                        OpenOption openOption5 = openOption2;
                        if (!(val3 != null ? !val3.equals(openOption5) : openOption5 != null)) {
                            bl = true;
                        } else {
                            Enumeration.Val val4 = StandardOpenOption$.MODULE$.Sync();
                            OpenOption openOption6 = openOption2;
                            if (!(val4 != null ? !val4.equals(openOption6) : openOption6 != null)) {
                                bl = true;
                            } else {
                                Enumeration.Val val5 = StandardOpenOption$.MODULE$.DSync();
                                OpenOption openOption7 = openOption2;
                                bl = !(val5 != null ? !val5.equals(openOption7) : openOption7 != null);
                            }
                        }
                    }
                }
                return bl;
            }
            {
                Function1.class.$init$((Function1)this);
                PartialFunction.class.$init$((PartialFunction)this);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq sortedChars = (Seq)((SeqLike)unsortedChars.distinct()).sortWith((Function2)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(char x, char y) {
                return this.value$1(x) < this.value$1(y);
            }

            private final int value$1(char x) {
                int n;
                char c = x;
                switch (c) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c));
                    }
                    case 's': {
                        n = 2;
                        break;
                    }
                    case 'w': {
                        n = 1;
                        break;
                    }
                    case 'r': {
                        n = 0;
                        break;
                    }
                    case 'd': {
                        n = 3;
                    }
                }
                return n;
            }
        });
        Seq chars2 = sortedChars.mkString().endsWith("sd") ? (Seq)sortedChars.takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(char c) {
                return c != 's';
            }
        }) : sortedChars;
        return chars2.contains((Object)BoxesRunTime.boxToCharacter((char)'r')) ? new RandomAccessFile(jfile, chars2.mkString()) : new RandomAccessFile(jfile, new StringBuilder().append('r').append((Object)chars2.mkString()).toString());
    }

    public void copy(InputStream in, OutputStream out) {
        byte[] buf = new byte[4096];
        int read2 = in.read(buf);
        while (read2 > -1) {
            if (read2 == 0) {
                Thread.sleep(100L);
            } else {
                out.write(buf, 0, read2);
            }
            read2 = in.read(buf);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object copy(ReadableByteChannel in, WritableByteChannel out) {
        Object object;
        Tuple2 tuple2 = new Tuple2((Object)in, (Object)out);
        if (tuple2 != null) {
            ReadableByteChannel readableByteChannel2 = (ReadableByteChannel)tuple2._1();
            WritableByteChannel writableByteChannel2 = (WritableByteChannel)tuple2._2();
            if (readableByteChannel2 instanceof FileChannel) {
                object = BoxesRunTime.boxToLong((long)((FileChannel)readableByteChannel2).transferTo(0L, Long.MAX_VALUE, writableByteChannel2));
                return object;
            }
            if (writableByteChannel2 instanceof FileChannel) {
                object = BoxesRunTime.boxToLong((long)((FileChannel)writableByteChannel2).transferFrom(readableByteChannel2, 0L, Long.MAX_VALUE));
                return object;
            }
        }
        ByteBuffer buf = DefaultResourceContext$.MODULE$.createNioBuffer((Option<Object>)None$.MODULE$, (Option<Channel>)new Some((Object)in), true);
        int read2 = in.read(buf);
        while (true) {
            if (read2 <= -1) {
                object = BoxedUnit.UNIT;
                return object;
            }
            if (read2 == 0) {
                Thread.sleep(100L);
            } else {
                buf.flip();
                out.write(buf);
            }
            buf.clear();
            read2 = in.read(buf);
        }
    }

    public Object tryCopy(Function0<BoxedUnit> failureCase, Object in, Object out) {
        Object object;
        Option<FileChannel> inFileChan = FileChannelExtractor$.MODULE$.unapply(in);
        Option<FileChannel> outFileChan = FileChannelExtractor$.MODULE$.unapply(out);
        Option<ReadableByteChannel> readableByteChan = ReadableByteChannelExtractor$.MODULE$.unapply(in);
        Option<WritableByteChannel> writableByteChan = WritableByteChannelExtractor$.MODULE$.unapply(out);
        if (Option$.MODULE$.option2Iterable(inFileChan).nonEmpty() && Option$.MODULE$.option2Iterable(outFileChan).nonEmpty()) {
            object = BoxesRunTime.boxToLong((long)((FileChannel)outFileChan.get()).transferFrom((ReadableByteChannel)inFileChan.get(), 0L, Long.MAX_VALUE));
        } else if (in instanceof InputStream && out instanceof OutputStream) {
            this.copy((InputStream)in, (OutputStream)out);
            object = BoxedUnit.UNIT;
        } else if (Option$.MODULE$.option2Iterable(readableByteChan).nonEmpty() && Option$.MODULE$.option2Iterable(outFileChan).nonEmpty()) {
            object = BoxesRunTime.boxToLong((long)((FileChannel)outFileChan.get()).transferFrom((ReadableByteChannel)readableByteChan.get(), 0L, Long.MAX_VALUE));
        } else if (Option$.MODULE$.option2Iterable(inFileChan).nonEmpty() && Option$.MODULE$.option2Iterable(writableByteChan).nonEmpty()) {
            object = BoxesRunTime.boxToLong((long)((FileChannel)inFileChan.get()).transferTo(0L, Long.MAX_VALUE, (WritableByteChannel)writableByteChan.get()));
        } else if (out instanceof WritableByteChannel && Option$.MODULE$.option2Iterable(readableByteChan).nonEmpty()) {
            object = this.copy((ReadableByteChannel)readableByteChan.get(), (WritableByteChannel)out);
        } else {
            failureCase.apply$mcV$sp();
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private FileUtils$() {
        MODULE$ = this;
    }
}

