/*
 * Decompiled with CFR 0.152.
 */
package scalax.io;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharsetEncoder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt;
import scala.runtime.RichLong;
import scalax.io.CloseAction$;
import scalax.io.CloseAction$Noop$;
import scalax.io.Codec;
import scalax.io.Codec$;
import scalax.io.Input;
import scalax.io.InputResource;
import scalax.io.LongTraversable;
import scalax.io.OpenOption;
import scalax.io.OpenedResource;
import scalax.io.Output;
import scalax.io.OutputConverter;
import scalax.io.OutputConverter$;
import scalax.io.OutputConverter$ByteArrayConverter$;
import scalax.io.OutputConverter$TraversableByteConverter$;
import scalax.io.OutputConverter$TraversableIntAsByteConverter$;
import scalax.io.OutputResource;
import scalax.io.Overwrite;
import scalax.io.OverwriteAll$;
import scalax.io.OverwriteSome;
import scalax.io.Resource$;
import scalax.io.Seekable;
import scalax.io.Seekable$;
import scalax.io.SeekableByteChannel;
import scalax.io.TraversableOnceOps$;
import scalax.io.managed.ByteChannelResource;
import scalax.io.managed.SeekableByteChannelResource;
import scalax.io.managed.WritableByteChannelResource;
import scalax.io.managed.WritableByteChannelResource$;
import scalax.io.processing.SeekableProcessor;

public abstract class Seekable$class {
    public static Object readWriteChannel(Seekable $this, Function1 f) {
        OpenedResource<SeekableByteChannel> resource = $this.underlyingChannel(false);
        try {
            Object exceptionResult1 = f.apply((Object)resource.get());
            return exceptionResult1;
        }
        finally {
            resource.close();
        }
    }

    public static Object appendChannel(Seekable $this, Function1 f) {
        OpenedResource<SeekableByteChannel> resource = $this.underlyingChannel(true);
        try {
            Object exceptionResult2 = f.apply((Object)resource.get());
            return exceptionResult2;
        }
        finally {
            resource.close();
        }
    }

    public static SeekableProcessor seekableProcessor(Seekable $this) {
        return new SeekableProcessor((Function0<OpenedResource<SeekableByteChannel>>)new Serializable($this){
            public static final long serialVersionUID;
            public final Seekable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final OpenedResource<SeekableByteChannel> apply() {
                return this.$outer.underlyingChannel(false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, $this.context());
    }

    public static void patch(Seekable $this, long position$1, String string, Overwrite overwrite, Codec codec) {
        Overwrite overwrite2;
        block12: {
            block9: {
                long l;
                block11: {
                    block10: {
                        block8: {
                            if (!(position$1 >= 0L)) {
                                throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"The patch starting position must be greater than or equal 0").toString());
                            }
                            if (!Option$.MODULE$.option2Iterable($this.size()).forall((Function1)new Serializable($this, position$1){
                                public static final long serialVersionUID;
                                public final long position$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final boolean apply(long l) {
                                    return this.apply$mcZJ$sp(l);
                                }

                                public boolean apply$mcZJ$sp(long v1) {
                                    return this.position$1 >= v1;
                                }
                                {
                                    this.position$1 = l;
                                }
                            }) && !codec.hasConstantSize()) break block8;
                            $this.patch(position$1, Predef$.MODULE$.wrapString(string), overwrite, OutputConverter$.MODULE$.charsToOutputFunction(codec));
                            break block9;
                        }
                        overwrite2 = overwrite;
                        OverwriteAll$ overwriteAll$ = OverwriteAll$.MODULE$;
                        Overwrite overwrite3 = overwrite2;
                        if (overwriteAll$ != null ? !overwriteAll$.equals(overwrite3) : overwrite3 != null) break block10;
                        l = Long.MIN_VALUE;
                        break block11;
                    }
                    if (!(overwrite2 instanceof OverwriteSome)) break block12;
                    l = ((OverwriteSome)overwrite2).replacementLength();
                }
                long replaced = l;
                byte[] bytes2 = string.getBytes(codec.name());
                long posInBytes = Seekable$class.charCountToByteCount($this, 0L, position$1, codec);
                if (overwrite.exists((Function1<Object, Object>)new Serializable($this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(long l) {
                        return this.apply$mcZJ$sp(l);
                    }

                    public boolean apply$mcZJ$sp(long v1) {
                        return v1 < 0L;
                    }
                })) {
                    $this.insert(posInBytes, bytes2, OutputConverter$ByteArrayConverter$.MODULE$);
                } else {
                    long l2;
                    Overwrite overwrite4 = overwrite;
                    OverwriteAll$ overwriteAll$ = OverwriteAll$.MODULE$;
                    if (!(overwrite4 != null ? !overwrite4.equals(overwriteAll$) : overwriteAll$ != null)) {
                        String string2 = string;
                        l2 = new StringOps(string2).size();
                    } else {
                        l2 = replaced;
                    }
                    long replacedInBytes = Seekable$class.charCountToByteCount($this, position$1, position$1 + l2, codec);
                    long l3 = replaced;
                    $this.patch(posInBytes, bytes2, (Overwrite)new OverwriteSome(BoxesRunTime.unboxToLong((Object)new RichLong(l3).max((Object)BoxesRunTime.boxToLong((long)replacedInBytes)))), OutputConverter$ByteArrayConverter$.MODULE$);
                }
            }
            return;
        }
        throw new MatchError((Object)overwrite2);
    }

    public static void patch(Seekable $this, long position2, Object data, Overwrite overwrite, OutputConverter converter) {
        boolean insertData;
        if (!(position2 >= 0L)) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"The patch starting position must be greater than or equal 0").toString());
        }
        TraversableOnce<Object> bytes2 = converter.toBytes(data);
        long actualPosition$1 = (long)converter.sizeInBytes() * position2;
        if (!(actualPosition$1 >= 0L)) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"The patch starting position must be greater than or equal 0").toString());
        }
        long replaced = overwrite.getOrElse((Function0<Object>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply() {
                return Long.MIN_VALUE;
            }

            public long apply$mcJ$sp() {
                return Long.MIN_VALUE;
            }
        });
        boolean appendData = Option$.MODULE$.option2Iterable($this.size()).forall((Function1)new Serializable($this, actualPosition$1){
            public static final long serialVersionUID;
            public final long actualPosition$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(long l) {
                return this.apply$mcZJ$sp(l);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return this.actualPosition$1 >= v1;
            }
            {
                this.actualPosition$1 = l;
            }
        });
        boolean bl = insertData = replaced <= 0L && replaced != Long.MIN_VALUE;
        if (appendData) {
            $this.append(bytes2, OutputConverter$TraversableByteConverter$.MODULE$);
        } else if (insertData) {
            $this.insert(actualPosition$1, bytes2, OutputConverter$TraversableByteConverter$.MODULE$);
        } else {
            Seekable$class.overwriteFileData($this, actualPosition$1, bytes2, replaced);
        }
    }

    public static Codec patch$default$4(Seekable $this, long position2, String string, Overwrite overwrite) {
        return Codec$.MODULE$.default();
    }

    public static void patchIntsAsBytes(Seekable $this, long position2, Overwrite overwrite, Seq data) {
        $this.patch(position2, data, overwrite, OutputConverter$TraversableIntAsByteConverter$.MODULE$);
    }

    public static void insert(Seekable $this, long position2, String string, Codec codec) {
        $this.insert(position2, codec.encode(string), OutputConverter$ByteArrayConverter$.MODULE$);
    }

    public static Object insert(Seekable $this, long position$2, Object data, OutputConverter converter) {
        Object object;
        TraversableOnce<Object> bytes2 = converter.toBytes(data);
        if (position$2 > -1L && Option$.MODULE$.option2Iterable($this.size()).forall((Function1)new Serializable($this, position$2){
            public static final long serialVersionUID;
            public final long position$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(long l) {
                return this.apply$mcZJ$sp(l);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return v1 <= this.position$2;
            }
            {
                this.position$2 = l;
            }
        })) {
            $this.append(bytes2, OutputConverter$TraversableByteConverter$.MODULE$);
            object = BoxedUnit.UNIT;
        } else {
            object = bytes2.hasDefiniteSize() && bytes2.size() <= 0xA00000 ? BoxesRunTime.boxToInteger((int)Seekable$class.insertDataInMemory($this, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longWrapper(position$2).max((Object)BoxesRunTime.boxToLong((long)0L))), bytes2)) : Seekable$class.insertDataTmpFile($this, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longWrapper(position$2).max((Object)BoxesRunTime.boxToLong((long)0L))), bytes2);
        }
        return object;
    }

    public static Codec insert$default$3(Seekable $this, long position2, String string) {
        return Codec$.MODULE$.default();
    }

    public static Object insertIntsAsBytes(Seekable $this, long position2, Seq data) {
        return $this.insert(position2, data, OutputConverter$TraversableIntAsByteConverter$.MODULE$);
    }

    public static void append(Seekable $this, Object data, OutputConverter converter) {
        TraversableOnce<Object> bytes$4 = converter.toBytes(data);
        $this.appendChannel(new Serializable($this, bytes$4){
            public static final long serialVersionUID;
            public final Seekable $outer;
            public final TraversableOnce bytes$4;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Object, Object> apply(SeekableByteChannel seekableByteChannel) {
                return Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, seekableByteChannel, this.bytes$4, -1L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bytes$4 = traversableOnce;
            }
        });
    }

    public static void appendIntsAsBytes(Seekable $this, Seq data) {
        $this.append(data, OutputConverter$TraversableIntAsByteConverter$.MODULE$);
    }

    public static void append(Seekable $this, String string, Codec codec) {
        $this.append(codec.encode(string), OutputConverter$ByteArrayConverter$.MODULE$);
    }

    public static Codec append$default$2(Seekable $this, String string) {
        return Codec$.MODULE$.default();
    }

    public static void appendStrings(Seekable $this, Traversable strings$1, String separator, Codec codec$2) {
        byte[] sepBytes$1 = codec$2.encode(separator);
        $this.appendChannel(new Serializable($this, strings$1, codec$2, sepBytes$1){
            public static final long serialVersionUID;
            public final Seekable $outer;
            public final Traversable strings$1;
            public final Codec codec$2;
            public final byte[] sepBytes$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(SeekableByteChannel channel$2) {
                return BoxesRunTime.unboxToBoolean((Object)this.strings$1.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this, channel$2){
                    public static final long serialVersionUID;
                    public final Seekable$.anonfun.appendStrings.1 $outer;
                    public final SeekableByteChannel channel$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(boolean addSep, String string) {
                        Object object = addSep ? Seekable$class.scalax$io$Seekable$$writeTo(this.$outer.$outer, this.channel$2, (TraversableOnce)Predef$.MODULE$.byteArrayOps(this.$outer.sepBytes$1), Long.MAX_VALUE) : BoxedUnit.UNIT;
                        Seekable$class.scalax$io$Seekable$$writeTo(this.$outer.$outer, this.channel$2, (TraversableOnce)Predef$.MODULE$.byteArrayOps(this.$outer.codec$2.encode(string)), Long.MAX_VALUE);
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.channel$2 = seekableByteChannel;
                    }
                }));
            }

            public Seekable scalax$io$Seekable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.strings$1 = traversable;
                this.codec$2 = codec;
                this.sepBytes$1 = byArray;
            }
        });
    }

    public static Codec appendStrings$default$3(Seekable $this, Traversable strings, String separator) {
        return Codec$.MODULE$.default();
    }

    public static String appendStrings$default$2(Seekable $this) {
        return "";
    }

    public static void truncate(Seekable $this, long position$6) {
        $this.readWriteChannel(new Serializable($this, position$6){
            public static final long serialVersionUID;
            public final long position$6;

            static {
                long l = serialVersionUID = 0L;
            }

            public final SeekableByteChannel apply(SeekableByteChannel seekableByteChannel) {
                return seekableByteChannel.truncate(this.position$6);
            }
            {
                this.position$6 = l;
            }
        });
    }

    public static void truncateString(Seekable $this, long position2, Codec codec) {
        long posInBytes$1 = Seekable$class.charCountToByteCount($this, 0L, position2, codec);
        $this.appendChannel(new Serializable($this, posInBytes$1){
            public static final long serialVersionUID;
            public final long posInBytes$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final SeekableByteChannel apply(SeekableByteChannel seekableByteChannel) {
                return seekableByteChannel.truncate(this.posInBytes$1);
            }
            {
                this.posInBytes$1 = l;
            }
        });
    }

    public static Codec truncateString$default$2(Seekable $this, long position2) {
        return Codec$.MODULE$.default();
    }

    private static int insertDataInMemory(Seekable $this, long position$3, TraversableOnce bytes$1) {
        return BoxesRunTime.unboxToInt($this.readWriteChannel(new Serializable($this, position$3, bytes$1){
            public static final long serialVersionUID;
            public final Seekable $outer;
            public final long position$3;
            public final TraversableOnce bytes$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(SeekableByteChannel channel) {
                channel.position(this.position$3);
                int dataToMove = (int)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longWrapper(channel.size() - this.position$3).min((Object)BoxesRunTime.boxToLong((long)0xA00000L)));
                Tuple2 buffers = new Tuple2((Object)ByteBuffer.allocateDirect(dataToMove), (Object)ByteBuffer.allocateDirect(dataToMove));
                channel.read((ByteBuffer)buffers._1());
                ((Buffer)buffers._1()).flip();
                buffers = buffers.swap();
                channel.position(this.position$3);
                Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.bytes$1, this.bytes$1.size());
                while (channel.position() < channel.size() - (long)((Buffer)buffers._2()).remaining()) {
                    channel.read((ByteBuffer)buffers._1());
                    ((Buffer)buffers._1()).flip();
                    channel.write((ByteBuffer)buffers._2(), channel.position() - (long)this.bytes$1.size());
                    buffers = buffers.swap();
                }
                return channel.write((ByteBuffer)buffers._2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.position$3 = l;
                this.bytes$1 = traversableOnce;
            }
        }));
    }

    public static Input tempFile(Seekable $this) {
        File file = File.createTempFile("SeekableCache", "tmp");
        return Resource$.MODULE$.fromFile(file);
    }

    private static Tuple2 insertDataTmpFile(Seekable $this, long position$4, TraversableOnce insertBytes$1) {
        Input tmp$1 = $this.tempFile();
        ((Output)((Object)tmp$1)).write($this.bytes().ldrop(position$4), OutputConverter$TraversableByteConverter$.MODULE$);
        return (Tuple2)$this.readWriteChannel(new Serializable($this, position$4, insertBytes$1, tmp$1){
            public static final long serialVersionUID;
            public final Seekable $outer;
            public final long position$4;
            public final TraversableOnce insertBytes$1;
            public final Input tmp$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<Object, Object> apply(SeekableByteChannel channel) {
                channel.position(this.position$4);
                Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.insertBytes$1, -1L);
                return Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.tmp$1.bytes(), BoxesRunTime.unboxToLong((Object)this.tmp$1.size().get()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.position$4 = l;
                this.insertBytes$1 = traversableOnce;
                this.tmp$1 = input;
            }
        });
    }

    private static Object overwriteFileData(Seekable $this, long position$5, TraversableOnce bytes$3, long replaced$1) {
        return $this.readWriteChannel(new Serializable($this, position$5, bytes$3, replaced$1){
            public static final long serialVersionUID;
            public final Seekable $outer;
            public final long position$5;
            public final TraversableOnce bytes$3;
            public final long replaced$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(SeekableByteChannel channel) {
                channel.position(this.position$5);
                Tuple2 tuple2 = Seekable$class.scalax$io$Seekable$$writeTo(this.$outer, channel, this.bytes$3, this.replaced$1);
                if (tuple2 != null) {
                    Object object;
                    Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                    long wrote = tuple22._1$mcJ$sp();
                    boolean earlyTermination = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
                    if (this.replaced$1 > channel.size() || this.position$5 + this.replaced$1 > channel.size()) {
                        object = channel.truncate(channel.position());
                    } else if (this.replaced$1 > wrote) {
                        long length = channel.size() - this.position$5 - this.replaced$1;
                        long srcIndex = this.position$5 + this.replaced$1;
                        long destIndex = this.position$5 + wrote;
                        Seekable$class.scalax$io$Seekable$$copySlice(this.$outer, channel, srcIndex, destIndex, (int)length);
                        object = channel.truncate(destIndex + length);
                    } else if (earlyTermination) {
                        long adjustedPosition = this.position$5 + this.replaced$1;
                        TraversableOnce traversableOnce = this.bytes$3;
                        object = traversableOnce instanceof LongTraversable ? this.$outer.insert(adjustedPosition, ((LongTraversable)traversableOnce).ldrop(wrote), OutputConverter$TraversableByteConverter$.MODULE$) : (traversableOnce instanceof Traversable ? this.$outer.insert(adjustedPosition, ((Traversable)traversableOnce).drop((int)wrote), OutputConverter$TraversableByteConverter$.MODULE$) : (traversableOnce instanceof Iterator ? this.$outer.insert(adjustedPosition, this.bytes$3, OutputConverter$TraversableByteConverter$.MODULE$) : this.$outer.insert(adjustedPosition, TraversableOnceOps$.MODULE$.drop(this.bytes$3, (int)wrote), OutputConverter$TraversableByteConverter$.MODULE$)));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.position$5 = l;
                this.bytes$3 = traversableOnce;
                this.replaced$1 = l2;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void scalax$io$Seekable$$copySlice(Seekable $this, SeekableByteChannel channel$1, long srcIndex$1, long destIndex$1, int length$2) {
        void $inlThis1;
        ByteBuffer buf$1 = $this.context().createNioBuffer((Option<Object>)None$.MODULE$, (Option<Channel>)new Some((Object)channel$1), false);
        Range range = new RichInt(0).to(length$2).by(buf$1.capacity());
        if (range.length() <= 0) return;
        int n = $inlThis1.last();
        int n2 = $inlThis1.start();
        while (true) {
            if (n2 == n) {
                int n3 = n2;
                Seekable$class.write$1($this, n3, channel$1, srcIndex$1, destIndex$1, length$2, buf$1);
                return;
            }
            int n4 = n2;
            Seekable$class.write$1($this, n4, channel$1, srcIndex$1, destIndex$1, length$2, buf$1);
            n2 += $inlThis1.step();
        }
    }

    public static final Tuple2 scalax$io$Seekable$$writeTo(Seekable $this, WritableByteChannel c$1, TraversableOnce bytes$2, long length$1) {
        Tuple2 tuple2;
        TraversableOnce traversableOnce = bytes$2;
        if (traversableOnce instanceof WrappedArray) {
            tuple2 = Seekable$class.writeArray$1($this, (byte[])((WrappedArray)traversableOnce).array(), c$1, bytes$2, length$1);
        } else if (traversableOnce instanceof ArrayOps) {
            tuple2 = Seekable$class.writeArray$1($this, (byte[])((ArrayOps)traversableOnce).toArray((ClassManifest)Manifest$.MODULE$.Byte()), c$1, bytes$2, length$1);
        } else {
            ByteBuffer buf$2 = $this.context().createNioBuffer((Option<Object>)(length$1 < 0L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)length$1))), (Option<Channel>)new Some((Object)c$1), false);
            BooleanRef earlyTermination$1 = new BooleanRef(false);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)Seekable$class.write$2($this, 0L, bytes$2, 0L, c$1, length$1, buf$2, earlyTermination$1)), (Object)BoxesRunTime.boxToBoolean((boolean)earlyTermination$1.elem));
        }
        return tuple2;
    }

    public static OutputResource underlyingOutput(Seekable $this) {
        OpenedResource<SeekableByteChannel> resource$2 = $this.underlyingChannel(false);
        return new WritableByteChannelResource<Object>((Function0<Object>)new Serializable($this, resource$2){
            public static final long serialVersionUID;
            public final OpenedResource resource$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final SeekableByteChannel apply() {
                return (SeekableByteChannel)this.resource$2.get();
            }
            {
                this.resource$2 = openedResource;
            }
        }, resource$2.context(), WritableByteChannelResource$.MODULE$.init$default$3());
    }

    public static InputResource toByteChannelResource(Seekable $this) {
        return new ByteChannelResource<Object>((Function0<Object>)new Serializable($this){
            public static final long serialVersionUID;
            public final Seekable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ByteChannel apply() {
                return Seekable$class.opened$1(this.$outer);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, $this.context(), CloseAction$Noop$.MODULE$, (Function0<Option<Object>>)new Serializable($this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final None$ apply() {
                return None$.MODULE$;
            }
        });
    }

    public static LongTraversable chars(Seekable $this, Codec codec) {
        return $this.toByteChannelResource().chars(codec);
    }

    public static LongTraversable bytesAsInts(Seekable $this) {
        return $this.toByteChannelResource().bytesAsInts();
    }

    public static LongTraversable bytes(Seekable $this) {
        return $this.toByteChannelResource().bytes();
    }

    public static LongTraversable blocks(Seekable $this, Option blockSize) {
        return $this.toByteChannelResource().blocks((Option<Object>)blockSize);
    }

    public static Option blocks$default$1(Seekable $this) {
        return None$.MODULE$;
    }

    private static long charCountToByteCount(Seekable $this, long start, long end2, Codec codec$1) {
        CharsetEncoder encoder$1 = codec$1.encoder();
        CharBuffer charBuffer$1 = CharBuffer.allocate(1);
        OpenedResource<SeekableByteChannel> resource$1 = $this.underlyingChannel(false);
        try {
            LongTraversable<Object> chars2 = new SeekableByteChannelResource(new Serializable($this, resource$1){
                public static final long serialVersionUID;
                public final OpenedResource resource$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final SeekableByteChannel apply(Seq<OpenOption> x$10) {
                    return (SeekableByteChannel)this.resource$1.get();
                }
                {
                    this.resource$1 = openedResource;
                }
            }, resource$1.context(), CloseAction$.MODULE$.apply((Function1)new Serializable($this, resource$1){
                public static final long serialVersionUID;
                public final OpenedResource resource$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Object x$11) {
                    this.resource$1.close();
                }
                {
                    this.resource$1 = openedResource;
                }
            }), (Function0<Option<Object>>)new Serializable($this, resource$1){
                public static final long serialVersionUID;
                public final OpenedResource resource$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Some<Object> apply() {
                    return new Some((Object)BoxesRunTime.boxToLong((long)((SeekableByteChannel)this.resource$1.get()).size()));
                }
                {
                    this.resource$1 = openedResource;
                }
            }, (Option<Seq<OpenOption>>)None$.MODULE$).chars(codec$1);
            LongTraversable segment = (LongTraversable)chars2.lslice(start, end2);
            long exceptionResult3 = BoxesRunTime.unboxToLong((Object)segment.$div$colon(BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable($this, codec$1, encoder$1, charBuffer$1){
                public static final long serialVersionUID;
                public final Codec codec$1;
                public final CharsetEncoder encoder$1;
                public final CharBuffer charBuffer$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final long apply(long replacedInBytes, char nextChar) {
                    this.charBuffer$1.clear();
                    this.charBuffer$1.put(nextChar);
                    this.charBuffer$1.flip();
                    ByteBuffer encoded = this.encoder$1.encode(this.charBuffer$1);
                    Predef$.MODULE$.byteArrayOps(((Object)BoxesRunTime.boxToCharacter((char)nextChar)).toString().getBytes(this.codec$1.name())).size();
                    return replacedInBytes + (long)encoded.limit();
                }
                {
                    this.codec$1 = codec;
                    this.encoder$1 = charsetEncoder;
                    this.charBuffer$1 = charBuffer;
                }
            }));
            return exceptionResult3;
        }
        finally {
            resource$1.close();
        }
    }

    public static final void write$1(Seekable $this, int done, SeekableByteChannel seekableByteChannel, long l, long l2, int n, ByteBuffer byteBuffer) {
        Object object = n < done + byteBuffer.capacity() ? byteBuffer.limit(n - done) : BoxedUnit.UNIT;
        byteBuffer.clear();
        seekableByteChannel.read(byteBuffer, l + (long)done);
        byteBuffer.flip();
        seekableByteChannel.write(byteBuffer, l2 + (long)done);
    }

    private static final Tuple2 writeArray$1(Seekable $this, byte[] array, WritableByteChannel writableByteChannel2, TraversableOnce traversableOnce, long l) {
        long count2 = l < 0L ? (long)traversableOnce.size() : BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longWrapper(l).min((Object)BoxesRunTime.boxToLong((long)traversableOnce.size())));
        int wrote = writableByteChannel2.write(ByteBuffer.wrap(array, 0, (int)count2));
        boolean isWriteAll = l > 0L;
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)wrote), (Object)BoxesRunTime.boxToBoolean((isWriteAll && l < (long)traversableOnce.size() ? 1 : 0) != 0));
    }

    private static final long write$2(Seekable $this, long written, TraversableOnce data, long acc, WritableByteChannel writableByteChannel2, long l, ByteBuffer byteBuffer, BooleanRef booleanRef) {
        long l2;
        int numBytes;
        Tuple2 tuple2;
        while ((tuple2 = TraversableOnceOps$.MODULE$.splitAt(data, numBytes = (l2 = l) == -1L || l2 == Long.MIN_VALUE ? byteBuffer.capacity() : (int)BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longWrapper(l - written).min((Object)BoxesRunTime.boxToLong((long)byteBuffer.capacity()))))) != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            TraversableOnce toWrite = (TraversableOnce)tuple22._1();
            TraversableOnce remaining = (TraversableOnce)tuple22._2();
            if (numBytes <= 0 && !remaining.nonEmpty()) {
                Predef$.MODULE$.assert(numBytes > 0 || remaining.nonEmpty());
            }
            byteBuffer.clear();
            toWrite.foreach((Function1)new Serializable($this, byteBuffer){
                public static final long serialVersionUID;
                public final ByteBuffer buf$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final ByteBuffer apply(byte by) {
                    return this.buf$2.put(by);
                }
                {
                    this.buf$2 = byteBuffer;
                }
            });
            byteBuffer.flip();
            long currentWrite = writableByteChannel2.write(byteBuffer);
            boolean bl = booleanRef.elem = l <= written + (long)numBytes && remaining.nonEmpty();
            if (booleanRef.elem || remaining.isEmpty()) {
                return currentWrite + acc;
            }
            acc = currentWrite + acc;
            data = remaining;
            written += (long)numBytes;
        }
        throw new MatchError(tuple2);
    }

    public static final ByteChannel opened$1(Seekable $this) {
        OpenedResource<SeekableByteChannel> r$1 = $this.underlyingChannel(false);
        r$1.get().position(0L);
        return new ByteChannel($this, r$1){
            private final SeekableByteChannel wrapped;
            private final OpenedResource r$1;

            public boolean isOpen() {
                return this.wrapped.isOpen();
            }

            public void close() {
                this.r$1.close();
            }

            public int write(ByteBuffer src) {
                return this.wrapped.write(src);
            }

            public int read(ByteBuffer dst) {
                return this.wrapped.read(dst);
            }
            {
                this.r$1 = openedResource;
                this.wrapped = (SeekableByteChannel)openedResource.get();
            }
        };
    }

    public static void $init$(Seekable $this) {
    }
}

