/*
 * Decompiled with CFR 0.152.
 */
package tyrex.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import tyrex.naming.MemoryBinding;
import tyrex.naming.MemoryContext;
import tyrex.tm.impl.ThreadContext;

public final class EnvContext
implements Context,
Serializable {
    private transient MemoryBinding _bindings;
    private Hashtable _env = new Hashtable();
    private String _path;

    public EnvContext(Hashtable hashtable) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._env.put(string, hashtable.get(string));
            }
        } else {
            hashtable = new Hashtable();
        }
        this._path = null;
    }

    EnvContext(MemoryBinding memoryBinding, Hashtable hashtable) {
        this._bindings = memoryBinding;
        this._path = this._bindings.getName();
        if (this._path.length() == 0) {
            this._path = null;
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this._env.put(string, hashtable.get(string));
            }
        } else {
            hashtable = new Hashtable();
        }
    }

    public Object lookup(String string) throws NamingException {
        Object object = this.getBindings().get(string);
        if (object != null) {
            if (object instanceof LinkRef) {
                String string2 = ((LinkRef)object).getLinkName();
                if (string2.startsWith(".")) {
                    return this.lookup(string2.substring(1));
                }
                return NamingManager.getInitialContext(this._env).lookup(string2);
            }
            if (object instanceof MemoryBinding) {
                return new EnvContext((MemoryBinding)object, this._env);
            }
            if (object instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(object, new CompositeName(string), this, this._env);
                }
                catch (Exception exception) {
                    throw new NamingException(exception.toString());
                }
            }
            return object;
        }
        return this.internalLookup(new CompositeName(string), true);
    }

    public Object lookup(Name name) throws NamingException {
        return this.internalLookup(name, true);
    }

    public Object lookupLink(String string) throws NamingException {
        return this.internalLookup(new CompositeName(string), false);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.internalLookup(name, false);
    }

    private Object internalLookup(Name name, boolean bl) throws NamingException {
        Object object;
        MemoryBinding memoryBinding;
        block11: {
            String string;
            memoryBinding = this.getBindings();
            while (true) {
                if (!name.isEmpty() && name.get(0).length() == 0) {
                    name = name.getSuffix(1);
                    continue;
                }
                if (name.isEmpty()) {
                    return new EnvContext(memoryBinding, this._env);
                }
                String string2 = name.get(0);
                if (name.size() > 1) {
                    object = memoryBinding.get(string2);
                    if (object instanceof Context) {
                        return ((Context)object).lookup(name.getSuffix(1));
                    }
                    if (!(object instanceof MemoryBinding)) {
                        throw new NotContextException(string2 + " is not a subcontext");
                    }
                    memoryBinding = (MemoryBinding)object;
                    name = name.getSuffix(1);
                    continue;
                }
                object = memoryBinding.get(string2);
                if (object == null) {
                    throw new NameNotFoundException(string2 + " not found");
                }
                if (!(object instanceof LinkRef) || !bl) break block11;
                string = ((LinkRef)object).getLinkName();
                if (!string.startsWith(".")) break;
                name = new CompositeName(string.substring(1));
            }
            return NamingManager.getInitialContext(this._env).lookup(string);
        }
        if (object instanceof MemoryBinding) {
            return new EnvContext((MemoryBinding)object, this._env);
        }
        if (object instanceof Reference) {
            try {
                return NamingManager.getObjectInstance(object, name, new EnvContext(memoryBinding, this._env), this._env);
            }
            catch (Exception exception) {
                throw new NamingException(exception.getMessage());
            }
        }
        return object;
    }

    public void bind(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void bind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void rebind(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void rebind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void unbind(String string) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void rename(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void rename(Name name, Name name2) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string.length() == 0) {
            return this.getBindings().enumerate(this, true);
        }
        return this.list(new CompositeName(string));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Object object;
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return this.getBindings().enumerate(this, true);
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this.getBindings();
        while (name.size() > 1) {
            object = memoryBinding.get(string);
            if (object instanceof Context) {
                return ((Context)object).list(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(string + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        if (string.length() == 0) {
            return memoryBinding.enumerate(this, true);
        }
        object = memoryBinding.get(string);
        if (object instanceof Context) {
            return ((Context)object).list("");
        }
        if (object instanceof MemoryBinding) {
            return ((MemoryBinding)object).enumerate(this, true);
        }
        throw new NotContextException(string + " is not a subcontext");
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string.length() == 0) {
            return this.getBindings().enumerate(this, false);
        }
        return this.listBindings(new CompositeName(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Object object;
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return this.getBindings().enumerate(this, false);
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this.getBindings();
        while (name.size() > 1) {
            object = memoryBinding.get(string);
            if (object instanceof Context) {
                return ((Context)object).listBindings(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(string + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        if (string.length() == 0) {
            return memoryBinding.enumerate(this, false);
        }
        object = memoryBinding.get(string);
        if (object instanceof Context) {
            return ((Context)object).listBindings("");
        }
        if (object instanceof MemoryBinding) {
            return ((MemoryBinding)object).enumerate(this, false);
        }
        throw new NotContextException(string + " is not a subcontext");
    }

    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void destroySubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("Context is read-only");
    }

    public NameParser getNameParser(String string) throws NamingException {
        if (string.length() == 0) {
            return MemoryContext.DefaultNameParser;
        }
        return this.getNameParser(new CompositeName(string));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return MemoryContext.DefaultNameParser;
        }
        String string = name.get(0);
        MemoryBinding memoryBinding = this.getBindings();
        while (name.size() > 1) {
            Object object = memoryBinding.get(string);
            if (object instanceof Context) {
                return ((Context)object).getNameParser(name.getSuffix(1));
            }
            if (!(object instanceof MemoryBinding)) {
                throw new NotContextException(string + " is not a subcontext");
            }
            memoryBinding = (MemoryBinding)object;
            name = name.getSuffix(1);
            string = name.get(0);
        }
        return MemoryContext.DefaultNameParser;
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        name2 = (Name)name2.clone();
        return name2.addAll(name);
    }

    public String composeName(String string, String string2) {
        return string2 + "/" + string;
    }

    public String getNameInNamespace() throws NamingException {
        return this._path == null ? "" : this._path;
    }

    public Object addToEnvironment(String string, Object object) {
        return this._env.put(string, object);
    }

    public Hashtable getEnvironment() {
        return this._env;
    }

    public Object removeFromEnvironment(String string) {
        return this._env.remove(string);
    }

    public void close() {
        this._env.clear();
    }

    public String toString() {
        return this._path == null ? "" : this._path;
    }

    private MemoryBinding getBindings() throws NamingException {
        if (this._bindings != null) {
            return this._bindings;
        }
        ThreadContext threadContext = ThreadContext.getThreadContext();
        MemoryBinding memoryBinding = threadContext.getMemoryBinding();
        if (this._path != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this._path, "/");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.length() <= 0) continue;
                MemoryBinding memoryBinding2 = (MemoryBinding)memoryBinding.get(string);
                if (memoryBinding2 == null || !(memoryBinding2 instanceof MemoryBinding)) {
                    throw new NamingException("Error: Environment naming context path java:" + this._path + " no longer bound to this thread");
                }
                memoryBinding = memoryBinding2;
            }
        }
        this._bindings = memoryBinding;
        return memoryBinding;
    }
}

