/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.w3c.dom.Document;
import play.i18n.Lang;

public class Http {

    public static interface Status {
        public static final int CONTINUE = 100;
        public static final int SWITCHING_PROTOCOLS = 101;
        public static final int OK = 200;
        public static final int CREATED = 201;
        public static final int ACCEPTED = 202;
        public static final int NON_AUTHORITATIVE_INFORMATION = 203;
        public static final int NO_CONTENT = 204;
        public static final int RESET_CONTENT = 205;
        public static final int PARTIAL_CONTENT = 206;
        public static final int MULTIPLE_CHOICES = 300;
        public static final int MOVED_PERMANENTLY = 301;
        public static final int FOUND = 302;
        public static final int SEE_OTHER = 303;
        public static final int NOT_MODIFIED = 304;
        public static final int USE_PROXY = 305;
        public static final int TEMPORARY_REDIRECT = 307;
        public static final int BAD_REQUEST = 400;
        public static final int UNAUTHORIZED = 401;
        public static final int PAYMENT_REQUIRED = 402;
        public static final int FORBIDDEN = 403;
        public static final int NOT_FOUND = 404;
        public static final int METHOD_NOT_ALLOWED = 405;
        public static final int NOT_ACCEPTABLE = 406;
        public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
        public static final int REQUEST_TIMEOUT = 408;
        public static final int CONFLICT = 409;
        public static final int GONE = 410;
        public static final int LENGTH_REQUIRED = 411;
        public static final int PRECONDITION_FAILED = 412;
        public static final int REQUEST_ENTITY_TOO_LARGE = 413;
        public static final int REQUEST_URI_TOO_LONG = 414;
        public static final int UNSUPPORTED_MEDIA_TYPE = 415;
        public static final int REQUESTED_RANGE_NOT_SATISFIABLE = 416;
        public static final int EXPECTATION_FAILED = 417;
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int NOT_IMPLEMENTED = 501;
        public static final int BAD_GATEWAY = 502;
        public static final int SERVICE_UNAVAILABLE = 503;
        public static final int GATEWAY_TIMEOUT = 504;
        public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    }

    public static interface HeaderNames {
        public static final String ACCEPT = "Accept";
        public static final String ACCEPT_CHARSET = "Accept-Charset";
        public static final String ACCEPT_ENCODING = "Accept-Encoding";
        public static final String ACCEPT_LANGUAGE = "Accept-Language";
        public static final String ACCEPT_RANGES = "Accept-Ranges";
        public static final String AGE = "Age";
        public static final String ALLOW = "Allow";
        public static final String AUTHORIZATION = "Authorization";
        public static final String CACHE_CONTROL = "Cache-Control";
        public static final String CONNECTION = "Connection";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_LOCATION = "Content-Location";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String COOKIE = "Cookie";
        public static final String DATE = "Date";
        public static final String ETAG = "Etag";
        public static final String EXPECT = "Expect";
        public static final String EXPIRES = "Expires";
        public static final String FROM = "From";
        public static final String HOST = "Host";
        public static final String IF_MATCH = "If-Match";
        public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
        public static final String IF_NONE_MATCH = "If-None-Match";
        public static final String IF_RANGE = "If-Range";
        public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
        public static final String LAST_MODIFIED = "Last-Modified";
        public static final String LOCATION = "Location";
        public static final String MAX_FORWARDS = "Max-Forwards";
        public static final String PRAGMA = "Pragma";
        public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
        public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
        public static final String RANGE = "Range";
        public static final String REFERER = "Referer";
        public static final String RETRY_AFTER = "Retry-After";
        public static final String SERVER = "Server";
        public static final String SET_COOKIE = "Set-Cookie";
        public static final String SET_COOKIE2 = "Set-Cookie2";
        public static final String TE = "Te";
        public static final String TRAILER = "Trailer";
        public static final String TRANSFER_ENCODING = "Transfer-Encoding";
        public static final String UPGRADE = "Upgrade";
        public static final String USER_AGENT = "User-Agent";
        public static final String VARY = "Vary";
        public static final String VIA = "Via";
        public static final String WARNING = "Warning";
        public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    }

    public static interface Cookies {
        public Cookie get(String var1);
    }

    public static class Cookie {
        private final String name;
        private final String value;
        private final int maxAge;
        private final String path;
        private final String domain;
        private final boolean secure;
        private final boolean httpOnly;

        public Cookie(String string2, String string3, int n, String string4, String string5, boolean bl, boolean bl2) {
            this.name = string2;
            this.value = string3;
            this.maxAge = n;
            this.path = string4;
            this.domain = string5;
            this.secure = bl;
            this.httpOnly = bl2;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public int maxAge() {
            return this.maxAge;
        }

        public String path() {
            return this.path;
        }

        public String domain() {
            return this.domain;
        }

        public boolean secure() {
            return this.secure;
        }

        public boolean httpOnly() {
            return this.httpOnly;
        }
    }

    public static class Flash
    extends HashMap<String, String> {
        public boolean isDirty = false;

        public Flash(Map<String, String> map2) {
            super(map2);
        }

        @Override
        public String remove(Object object) {
            this.isDirty = true;
            return (String)super.remove(object);
        }

        @Override
        public String put(String string2, String string3) {
            this.isDirty = true;
            return super.put(string2, string3);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map2) {
            this.isDirty = true;
            super.putAll(map2);
        }

        @Override
        public void clear() {
            this.isDirty = true;
            super.clear();
        }
    }

    public static class Session
    extends HashMap<String, String> {
        public boolean isDirty = false;

        public Session(Map<String, String> map2) {
            super(map2);
        }

        @Override
        public String remove(Object object) {
            this.isDirty = true;
            return (String)super.remove(object);
        }

        @Override
        public String put(String string2, String string3) {
            this.isDirty = true;
            return super.put(string2, string3);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map2) {
            this.isDirty = true;
            super.putAll(map2);
        }

        @Override
        public void clear() {
            this.isDirty = true;
            super.clear();
        }
    }

    public static class Response
    implements HeaderNames {
        private final Map<String, String> headers = new HashMap<String, String>();
        private final List<Cookie> cookies = new ArrayList<Cookie>();
        private final List<String> discardedCookies = new ArrayList<String>();

        public void setHeader(String string2, String string3) {
            this.headers.put(string2, string3);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setContentType(String string2) {
            this.setHeader("Content-Type", string2);
        }

        public void setCookie(String string2, String string3) {
            this.setCookie(string2, string3, -1);
        }

        public void setCookie(String string2, String string3, int n) {
            this.setCookie(string2, string3, n, "/");
        }

        public void setCookie(String string2, String string3, int n, String string4) {
            this.setCookie(string2, string3, n, string4, null);
        }

        public void setCookie(String string2, String string3, int n, String string4, String string5) {
            this.setCookie(string2, string3, n, string4, string5, false, false);
        }

        public void setCookie(String string2, String string3, int n, String string4, String string5, boolean bl, boolean bl2) {
            this.cookies.add(new Cookie(string2, string3, n, string4, string5, bl, bl2));
        }

        public void discardCookies(String ... stringArray) {
            this.discardedCookies.addAll(Arrays.asList(stringArray));
        }

        public Iterable<Cookie> cookies() {
            return this.cookies;
        }

        public Iterable<String> discardedCookies() {
            return this.discardedCookies;
        }
    }

    public static class RequestBody {
        public boolean isMaxSizeExceeded() {
            return false;
        }

        public MultipartFormData asMultipartFormData() {
            return null;
        }

        public Map<String, String[]> asFormUrlEncoded() {
            return null;
        }

        public RawBuffer asRaw() {
            return null;
        }

        public String asText() {
            return null;
        }

        public Document asXml() {
            return null;
        }

        public JsonNode asJson() {
            return null;
        }

        public <T> T as(Class<T> clazz) {
            if (this.getClass().isAssignableFrom(clazz)) {
                return (T)this;
            }
            return null;
        }
    }

    public static abstract class MultipartFormData {
        public abstract Map<String, String[]> asFormUrlEncoded();

        public abstract List<FilePart> getFiles();

        public FilePart getFile(String string2) {
            for (FilePart filePart : this.getFiles()) {
                if (!filePart.getKey().equals(string2)) continue;
                return filePart;
            }
            return null;
        }

        public static class FilePart {
            final String key;
            final String filename;
            final String contentType;
            final File file;

            public FilePart(String string2, String string3, String string4, File file2) {
                this.key = string2;
                this.filename = string3;
                this.contentType = string4;
                this.file = file2;
            }

            public String getKey() {
                return this.key;
            }

            public String getFilename() {
                return this.filename;
            }

            public String getContentType() {
                return this.contentType;
            }

            public File getFile() {
                return this.file;
            }
        }
    }

    public static abstract class RawBuffer {
        public abstract Long size();

        public abstract byte[] asBytes(int var1);

        public abstract byte[] asBytes();

        public abstract File asFile();
    }

    public static abstract class Request
    extends RequestHeader {
        private String username = null;

        public abstract RequestBody body();

        public String username() {
            return this.username;
        }

        public void setUsername(String string2) {
            this.username = string2;
        }
    }

    public static abstract class RequestHeader {
        public abstract String uri();

        public abstract String method();

        public abstract String remoteAddress();

        public abstract String host();

        public abstract String path();

        public abstract List<Lang> acceptLanguages();

        public abstract List<String> accept();

        public abstract boolean accepts(String var1);

        public abstract Map<String, String[]> queryString();

        public abstract Cookies cookies();

        public abstract Map<String, String[]> headers();

        public String getHeader(String string2) {
            String[] stringArray = null;
            for (String string3 : this.headers().keySet()) {
                if (!string2.toLowerCase().equals(string3.toLowerCase())) continue;
                stringArray = this.headers().get(string3);
                break;
            }
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            return stringArray[0];
        }
    }

    public static class Context {
        public static ThreadLocal<Context> current = new ThreadLocal();
        private final Request request;
        private final Response response;
        private final Session session;
        private final Flash flash;
        public Map<String, Object> args = new HashMap<String, Object>(16);

        public static Context current() {
            Context context = current.get();
            if (context == null) {
                throw new RuntimeException("There is no HTTP Context available from here.");
            }
            return context;
        }

        public Context(Request request, Map<String, String> map2, Map<String, String> map3) {
            this.request = request;
            this.response = new Response();
            this.session = new Session(map2);
            this.flash = new Flash(map3);
        }

        public Request request() {
            return this.request;
        }

        public Response response() {
            return this.response;
        }

        public Session session() {
            return this.session;
        }

        public Flash flash() {
            return this.flash;
        }

        public static class Implicit {
            public static Response response() {
                return Context.current().response();
            }

            public static Request request() {
                return Context.current().request();
            }

            public static Flash flash() {
                return Context.current().flash();
            }

            public static Session session() {
                return Context.current().session();
            }

            public static Lang lang() {
                return Lang.preferred(Context.current().request().acceptLanguages());
            }

            public static Context ctx() {
                return Context.current();
            }
        }
    }
}

