/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import play.core.j.JavaParsers;
import play.mvc.Http;

public interface BodyParser {
    public play.api.mvc.BodyParser<Http.RequestBody> parser(int var1);

    public static class MultipartFormData
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(int n) {
            return JavaParsers.multipartFormData(n);
        }
    }

    public static class FormUrlEncoded
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(int n) {
            return JavaParsers.formUrlEncoded(n);
        }
    }

    public static class Raw
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(int n) {
            return JavaParsers.raw(n);
        }
    }

    public static class TolerantText
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(int n) {
            return JavaParsers.tolerantText(n);
        }
    }

    public static class Text
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(int n) {
            return JavaParsers.text(n);
        }
    }

    public static class TolerantXml
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(int n) {
            return JavaParsers.tolerantXml(n);
        }
    }

    public static class Xml
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(int n) {
            return JavaParsers.xml(n);
        }
    }

    public static class TolerantJson
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(int n) {
            return JavaParsers.tolerantJson(n);
        }
    }

    public static class Json
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(int n) {
            return JavaParsers.json(n);
        }
    }

    public static class AnyContent
    implements BodyParser {
        @Override
        public play.api.mvc.BodyParser<Http.RequestBody> parser(int n) {
            return JavaParsers.anyContent(n);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Of {
        public Class<? extends BodyParser> value();

        public int maxLength() default 0x7FFFFFFF;
    }
}

