/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilderBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.w3c.dom.Document;
import play.api.libs.concurrent.STMPromise;
import play.libs.F;
import play.libs.XML;
import scala.runtime.AbstractFunction0;

public class WS {
    private static AsyncHttpClient client = play.api.libs.ws.WS.client();

    public static WSRequestHolder url(String string2) {
        return new WSRequestHolder(string2);
    }

    public static class Response {
        private com.ning.http.client.Response ahcResponse;

        public Response(com.ning.http.client.Response response) {
            this.ahcResponse = response;
        }

        public int getStatus() {
            return this.ahcResponse.getStatusCode();
        }

        public String getHeader(String string2) {
            return this.ahcResponse.getHeader(string2);
        }

        public String getBody() {
            try {
                return this.ahcResponse.getResponseBody();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public Document asXml() {
            try {
                return XML.fromInputStream(this.ahcResponse.getResponseBodyAsStream(), "utf-8");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public JsonNode asJson() {
            String string2 = this.getBody();
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (JsonNode)objectMapper.readValue(string2, JsonNode.class);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static class WSRequestHolder {
        private final String url;
        private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
        private Map<String, Collection<String>> queryParameters = new HashMap<String, Collection<String>>();
        private String username = null;
        private String password = null;
        private Realm.AuthScheme scheme = null;

        public WSRequestHolder(String string2) {
            this.url = string2;
        }

        public WSRequestHolder setHeader(String string2, String string3) {
            if (this.headers.containsKey(string2)) {
                Collection<String> collection = this.headers.get(string2);
                collection.add(string3);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string3);
                this.headers.put(string2, arrayList);
            }
            return this;
        }

        public WSRequestHolder setQueryParameter(String string2, String string3) {
            if (this.queryParameters.containsKey(string2)) {
                Collection<String> collection = this.headers.get(string2);
                collection.add(string3);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string3);
                this.queryParameters.put(string2, arrayList);
            }
            return this;
        }

        public WSRequestHolder setAuth(String string2, String string3, Realm.AuthScheme authScheme) {
            this.username = string2;
            this.password = string3;
            this.scheme = authScheme;
            return this;
        }

        public F.Promise<Response> get() {
            return this.execute("GET");
        }

        public F.Promise<Response> post(String string2) {
            return this.executeString("POST", string2);
        }

        public F.Promise<Response> put(String string2) {
            return this.executeString("PUT", string2);
        }

        public F.Promise<Response> post(InputStream inputStream) {
            return this.executeIS("POST", inputStream);
        }

        public F.Promise<Response> put(InputStream inputStream) {
            return this.executeIS("PUT", inputStream);
        }

        public F.Promise<Response> post(File file2) {
            return this.executeFile("POST", file2);
        }

        public F.Promise<Response> put(File file2) {
            return this.executeFile("PUT", file2);
        }

        public F.Promise<Response> delete() {
            return this.execute("DELETE");
        }

        public F.Promise<Response> head() {
            return this.execute("HEAD");
        }

        public F.Promise<Response> option() {
            return this.execute("OPTION");
        }

        private F.Promise<Response> execute(String string2) {
            WSRequest wSRequest = (WSRequest)((WSRequest)((WSRequest)new WSRequest(string2).setUrl(this.url)).setHeaders(this.headers)).setQueryParameters(new FluentStringsMap(this.queryParameters));
            if (this.username != null && this.password != null && this.scheme != null) {
                wSRequest.auth(this.username, this.password, this.scheme);
            }
            return wSRequest.execute();
        }

        private F.Promise<Response> executeString(String string2, String string3) {
            WSRequest wSRequest = (WSRequest)((WSRequest)((WSRequest)((WSRequest)new WSRequest(string2).setBody(string3)).setUrl(this.url)).setHeaders(this.headers)).setQueryParameters(new FluentStringsMap(this.queryParameters));
            if (this.username != null && this.password != null && this.scheme != null) {
                wSRequest.auth(this.username, this.password, this.scheme);
            }
            return wSRequest.execute();
        }

        private F.Promise<Response> executeIS(String string2, InputStream inputStream) {
            WSRequest wSRequest = (WSRequest)((WSRequest)((WSRequest)((WSRequest)new WSRequest(string2).setBody(inputStream)).setUrl(this.url)).setHeaders(this.headers)).setQueryParameters(new FluentStringsMap(this.queryParameters));
            if (this.username != null && this.password != null && this.scheme != null) {
                wSRequest.auth(this.username, this.password, this.scheme);
            }
            return wSRequest.execute();
        }

        private F.Promise<Response> executeFile(String string2, File file2) {
            WSRequest wSRequest = (WSRequest)((WSRequest)((WSRequest)((WSRequest)new WSRequest(string2).setBody(file2)).setUrl(this.url)).setHeaders(this.headers)).setQueryParameters(new FluentStringsMap(this.queryParameters));
            if (this.username != null && this.password != null && this.scheme != null) {
                wSRequest.auth(this.username, this.password, this.scheme);
            }
            return wSRequest.execute();
        }
    }

    public static class WSRequest
    extends RequestBuilderBase<WSRequest> {
        public WSRequest(String string2) {
            super(WSRequest.class, string2, false);
        }

        private WSRequest auth(String string2, String string3, Realm.AuthScheme authScheme) {
            this.setRealm(new Realm.RealmBuilder().setScheme(authScheme).setPrincipal(string2).setPassword(string3).setUsePreemptiveAuth(true).build());
            return this;
        }

        private F.Promise<Response> execute() {
            final STMPromise sTMPromise = new STMPromise();
            try {
                client.executeRequest((Request)this.request, (AsyncHandler)new AsyncCompletionHandler<com.ning.http.client.Response>(){

                    public com.ning.http.client.Response onCompleted(com.ning.http.client.Response response) {
                        final com.ning.http.client.Response response2 = response;
                        sTMPromise.redeem(new AbstractFunction0<Response>(){

                            public Response apply() {
                                return new Response(response2);
                            }
                        });
                        return response;
                    }

                    public void onThrowable(Throwable throwable) {
                        sTMPromise.throwing(throwable);
                    }
                });
            }
            catch (IOException iOException) {
                sTMPromise.throwing(iOException);
            }
            return new F.Promise(sTMPromise);
        }
    }
}

