/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import play.api.libs.concurrent.Promise$;
import play.api.libs.concurrent.Recover;
import play.core.j.JavaPromise;
import scala.Function1;
import scala.runtime.AbstractFunction0;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;

public class F {
    public static <A> Some<A> Some(A a) {
        return new Some<A>(a);
    }

    public static None None() {
        return new None();
    }

    public static <A, B> Tuple<A, B> Tuple(A a, B b) {
        return new Tuple<A, B>(a, b);
    }

    public static <A, B, C> Tuple3<A, B, C> Tuple3(A a, B b, C c) {
        return new Tuple3<A, B, C>(a, b, c);
    }

    public static <A, B, C, D> Tuple4<A, B, C, D> Tuple4(A a, B b, C c, D d) {
        return new Tuple4<A, B, C, D>(a, b, c, d);
    }

    public static <A, B, C, D, E> Tuple5<A, B, C, D, E> Tuple5(A a, B b, C c, D d, E e) {
        return new Tuple5<A, B, C, D, E>(a, b, c, d, e);
    }

    public static class Tuple5<A, B, C, D, E> {
        public final A _1;
        public final B _2;
        public final C _3;
        public final D _4;
        public final E _5;

        public Tuple5(A a, B b, C c, D d, E e) {
            this._1 = a;
            this._2 = b;
            this._3 = c;
            this._4 = d;
            this._5 = e;
        }

        public String toString() {
            return "Tuple5(_1: " + this._1 + ", _2: " + this._2 + ", _3:" + this._3 + ", _4:" + this._4 + ", _5:" + this._5 + ")";
        }
    }

    public static class Tuple4<A, B, C, D> {
        public final A _1;
        public final B _2;
        public final C _3;
        public final D _4;

        public Tuple4(A a, B b, C c, D d) {
            this._1 = a;
            this._2 = b;
            this._3 = c;
            this._4 = d;
        }

        public String toString() {
            return "Tuple4(_1: " + this._1 + ", _2: " + this._2 + ", _3:" + this._3 + ", _4:" + this._4 + ")";
        }
    }

    public static class Tuple3<A, B, C> {
        public final A _1;
        public final B _2;
        public final C _3;

        public Tuple3(A a, B b, C c) {
            this._1 = a;
            this._2 = b;
            this._3 = c;
        }

        public String toString() {
            return "Tuple3(_1: " + this._1 + ", _2: " + this._2 + ", _3:" + this._3 + ")";
        }
    }

    public static class Tuple<A, B> {
        public final A _1;
        public final B _2;

        public Tuple(A a, B b) {
            this._1 = a;
            this._2 = b;
        }

        public String toString() {
            return "Tuple2(_1: " + this._1 + ", _2: " + this._2 + ")";
        }
    }

    public static class Either<A, B> {
        public final Option<A> left;
        public final Option<B> right;

        private Either(Option<A> option, Option<B> option2) {
            this.left = option;
            this.right = option2;
        }

        public static <A, B> Either<A, B> Left(A a) {
            return new Either<A, B>(F.Some(a), F.None());
        }

        public static <A, B> Either<A, B> Right(B b) {
            return new Either<A, B>(F.None(), F.Some(b));
        }

        public String toString() {
            return "Either(left: " + this.left + ", right: " + this.right + ")";
        }
    }

    public static class Some<T>
    extends Option<T> {
        final T value;

        public Some(T t) {
            this.value = t;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.singletonList(this.value).iterator();
        }

        public String toString() {
            return "Some(" + this.value + ")";
        }
    }

    public static class None<T>
    extends Option<T> {
        @Override
        public boolean isDefined() {
            return false;
        }

        @Override
        public T get() {
            throw new IllegalStateException("No value");
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.emptyList().iterator();
        }

        public String toString() {
            return "None";
        }
    }

    public static abstract class Option<T>
    implements Iterable<T> {
        public abstract boolean isDefined();

        public abstract T get();

        public static <T> None<T> None() {
            return new None();
        }

        public static <T> Some<T> Some(T t) {
            return new Some<T>(t);
        }

        public T getOrElse(T t) {
            if (this.isDefined()) {
                return this.get();
            }
            return t;
        }

        public <A> Option<A> map(Function<T, A> function) {
            if (this.isDefined()) {
                try {
                    return Option.Some(function.apply(this.get()));
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            return Option.None();
        }
    }

    public static class Promise<A> {
        private final play.api.libs.concurrent.Promise<A> promise;

        public static <A> Promise<List<A>> waitAll(Promise<A> ... promiseArray) {
            return new Promise<play.api.libs.concurrent.Promise<List<A>>>(JavaPromise.sequence(Arrays.asList(promiseArray)));
        }

        public static <A> Promise<List<A>> waitAll(Iterable<Promise<A>> iterable) {
            ArrayList arrayList = new ArrayList();
            for (Promise<A> promise : iterable) {
                arrayList.add(promise);
            }
            return new Promise(JavaPromise.sequence(arrayList));
        }

        public Promise(play.api.libs.concurrent.Promise<A> promise) {
            this.promise = promise;
        }

        public Promise(final A a) {
            this((A)Promise$.MODULE$.pure(new AbstractFunction0<A>(){

                public A apply() {
                    return a;
                }
            }));
        }

        public A get() {
            return this.promise.value().get();
        }

        public A get(Long l, TimeUnit timeUnit) {
            return this.promise.await(l, timeUnit).get();
        }

        public A get(Long l) {
            return this.get(l, TimeUnit.MILLISECONDS);
        }

        public void onRedeem(final Callback<A> callback) {
            this.promise.onRedeem((Function1<A, BoxedUnit>)new AbstractFunction1<A, BoxedUnit>(){

                public BoxedUnit apply(A a) {
                    try {
                        callback.invoke(a);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    return null;
                }
            });
        }

        public <B> Promise<B> map(final Function<A, B> function) {
            return new Promise(this.promise.map(new AbstractFunction1<A, B>(){

                public B apply(A a) {
                    try {
                        return function.apply(a);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            }));
        }

        public Promise<A> recover(final Function<Throwable, A> function) {
            return new Promise(this.promise.recover(new Recover<A>(){

                @Override
                public A recover(Throwable throwable) {
                    try {
                        return function.apply(throwable);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Throwable throwable2) {
                        throw new RuntimeException(throwable2);
                    }
                }
            }));
        }

        public <B> Promise<B> flatMap(final Function<A, Promise<B>> function) {
            return new Promise(this.promise.flatMap(new AbstractFunction1<A, play.api.libs.concurrent.Promise<B>>(){

                public play.api.libs.concurrent.Promise<B> apply(A a) {
                    try {
                        return ((Promise)function.apply(a)).promise;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            }));
        }

        public play.api.libs.concurrent.Promise<A> getWrappedPromise() {
            return this.promise;
        }
    }

    public static interface Function3<A, B, C, R> {
        public R apply(A var1, B var2, C var3) throws Throwable;
    }

    public static interface Function2<A, B, R> {
        public R apply(A var1, B var2) throws Throwable;
    }

    public static interface Function<A, R> {
        public R apply(A var1) throws Throwable;
    }

    public static interface Function0<R> {
        public R apply() throws Throwable;
    }

    public static interface Callback3<A, B, C> {
        public void invoke(A var1, B var2, C var3) throws Throwable;
    }

    public static interface Callback2<A, B> {
        public void invoke(A var1, B var2) throws Throwable;
    }

    public static interface Callback<A> {
        public void invoke(A var1) throws Throwable;
    }

    public static interface Callback0 {
        public void invoke() throws Throwable;
    }
}

