/*
 * Decompiled with CFR 0.152.
 */
package play.db.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import play.Application;
import play.Configuration;
import play.Plugin;

public class JPAPlugin
extends Plugin {
    private final Application application;
    private final Map<String, EntityManagerFactory> emfs = new HashMap<String, EntityManagerFactory>();

    public JPAPlugin(Application application) {
        this.application = application;
    }

    @Override
    public void onStart() {
        Configuration configuration = Configuration.root().getConfig("jpa");
        if (configuration != null) {
            for (String string2 : configuration.keys()) {
                String string3 = configuration.getString(string2);
                this.emfs.put(string2, Persistence.createEntityManagerFactory((String)string3));
            }
        }
    }

    private boolean isPluginDisabled() {
        String string2 = this.application.configuration().getString("jpaplugin");
        return string2 != null && string2.equals("disabled");
    }

    @Override
    public boolean enabled() {
        return !this.isPluginDisabled();
    }

    @Override
    public void onStop() {
        for (EntityManagerFactory entityManagerFactory : this.emfs.values()) {
            entityManagerFactory.close();
        }
    }

    public EntityManager em(String string2) {
        EntityManagerFactory entityManagerFactory = this.emfs.get(string2);
        if (entityManagerFactory == null) {
            return null;
        }
        return entityManagerFactory.createEntityManager();
    }
}

