/*
 * Decompiled with CFR 0.152.
 */
package play.db.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import play.Application;
import play.Play;
import play.db.jpa.JPAPlugin;
import play.libs.F;

public class JPA {
    static ThreadLocal<EntityManager> currentEntityManager = new ThreadLocal();

    public static EntityManager em(String string2) {
        Application application = Play.application();
        if (application == null) {
            throw new RuntimeException("No application running");
        }
        JPAPlugin jPAPlugin = application.plugin(JPAPlugin.class);
        if (jPAPlugin == null) {
            throw new RuntimeException("No JPA EntityManagerFactory configured for name [" + string2 + "]");
        }
        EntityManager entityManager = jPAPlugin.em(string2);
        if (entityManager == null) {
            throw new RuntimeException("No JPA EntityManagerFactory configured for name [" + string2 + "]");
        }
        return entityManager;
    }

    public static EntityManager em() {
        EntityManager entityManager = currentEntityManager.get();
        if (entityManager == null) {
            throw new RuntimeException("No EntityManager bound to this thread. Try to annotate your action method with @play.db.jpa.Transactional");
        }
        return entityManager;
    }

    public static void bindForCurrentThread(EntityManager entityManager) {
        currentEntityManager.set(entityManager);
    }

    public static <T> T withTransaction(F.Function0<T> function0) throws Throwable {
        return JPA.withTransaction("default", false, function0);
    }

    public static void withTransaction(final F.Callback0 callback0) {
        try {
            JPA.withTransaction("default", false, new F.Function0<Void>(){

                @Override
                public Void apply() throws Throwable {
                    callback0.invoke();
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static <T> T withTransaction(String string2, boolean bl, F.Function0<T> function0) throws Throwable {
        EntityManager entityManager = null;
        EntityTransaction entityTransaction = null;
        try {
            entityManager = JPA.em(string2);
            JPA.bindForCurrentThread(entityManager);
            if (!bl) {
                entityTransaction = entityManager.getTransaction();
                entityTransaction.begin();
            }
            T t = function0.apply();
            if (entityTransaction != null) {
                if (entityTransaction.getRollbackOnly()) {
                    entityTransaction.rollback();
                } else {
                    entityTransaction.commit();
                }
            }
            T t2 = t;
            return t2;
        }
        catch (Throwable throwable) {
            if (entityTransaction != null) {
                try {
                    entityTransaction.rollback();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        finally {
            JPA.bindForCurrentThread(null);
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }
}

