/*
 * Decompiled with CFR 0.152.
 */
package play.db.ebean;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.EbeanServerFactory;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.ddl.DdlGenerator;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.sql.DataSource;
import play.Application;
import play.Configuration;
import play.Plugin;
import play.api.libs.Files;
import play.db.DB;

public class EbeanPlugin
extends Plugin {
    private final Application application;
    private final Map<String, EbeanServer> servers = new HashMap<String, EbeanServer>();

    public EbeanPlugin(Application application) {
        this.application = application;
    }

    @Override
    public void onStart() {
        Configuration configuration = Configuration.root().getConfig("ebean");
        if (configuration != null) {
            for (String string2 : configuration.keys()) {
                File file2;
                String string3;
                boolean bl;
                ServerConfig serverConfig = new ServerConfig();
                serverConfig.setName(string2);
                try {
                    serverConfig.setDataSource((DataSource)new WrappingDatasource(DB.getDataSource(string2)));
                }
                catch (Exception exception) {
                    throw configuration.reportError(string2, exception.getMessage(), exception);
                }
                if (string2.equals("default")) {
                    serverConfig.setDefaultServer(true);
                }
                String[] stringArray = configuration.getString(string2).split(",");
                HashSet<String> hashSet = new HashSet<String>();
                for (String string4 : stringArray) {
                    if ((string4 = string4.trim()).endsWith(".*")) {
                        hashSet.addAll(this.application.getTypesAnnotatedWith(string4.substring(0, string4.length() - 2), Entity.class));
                        hashSet.addAll(this.application.getTypesAnnotatedWith(string4.substring(0, string4.length() - 2), Embeddable.class));
                        continue;
                    }
                    hashSet.add(string4);
                }
                for (String string5 : hashSet) {
                    try {
                        serverConfig.addClass(Class.forName(string5, true, this.application.classloader()));
                    }
                    catch (Throwable throwable) {
                        throw configuration.reportError(string2, "Cannot register class [" + string5 + "] in Ebean server", throwable);
                    }
                }
                this.servers.put(string2, EbeanServerFactory.create((ServerConfig)serverConfig));
                if (this.application.isProd() || !(bl = !"disabled".equals(this.application.configuration().getString("evolutionplugin"))) || (string3 = EbeanPlugin.generateEvolutionScript(this.servers.get(string2), serverConfig)) == null || (file2 = this.application.getFile("conf/evolutions/" + string2 + "/1.sql")).exists() && !Files.readFile(file2).startsWith("# --- Created by Ebean DDL")) continue;
                Files.createDirectory(this.application.getFile("conf/evolutions/" + string2));
                Files.writeFileIfChanged(file2, string3);
            }
        }
    }

    public static String generateEvolutionScript(EbeanServer ebeanServer, ServerConfig serverConfig) {
        DdlGenerator ddlGenerator = new DdlGenerator((SpiEbeanServer)ebeanServer, serverConfig.getDatabasePlatform(), serverConfig);
        String string2 = ddlGenerator.generateCreateDdl();
        String string3 = ddlGenerator.generateDropDdl();
        if (string2 == null || string2.trim().isEmpty()) {
            return null;
        }
        return "# --- Created by Ebean DDL\n# To stop Ebean DDL generation, remove this comment and start using Evolutions\n\n# --- !Ups\n\n" + string2 + "\n" + "# --- !Downs\n" + "\n" + string3;
    }

    static class WrappingDatasource
    implements DataSource {
        final DataSource wrapped;

        public Connection wrap(Connection connection) throws SQLException {
            connection.setAutoCommit(false);
            return connection;
        }

        public WrappingDatasource(DataSource dataSource) {
            this.wrapped = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.wrap(this.wrapped.getConnection());
        }

        @Override
        public Connection getConnection(String string2, String string3) throws SQLException {
            return this.wrap(this.wrapped.getConnection(string2, string3));
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.wrapped.getLoginTimeout();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.wrapped.getLogWriter();
        }

        @Override
        public void setLoginTimeout(int n) throws SQLException {
            this.wrapped.setLoginTimeout(n);
        }

        @Override
        public void setLogWriter(PrintWriter printWriter) throws SQLException {
            this.wrapped.setLogWriter(printWriter);
        }

        @Override
        public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return this.wrapped.isWrapperFor(clazz);
        }

        @Override
        public <T> T unwrap(Class<T> clazz) throws SQLException {
            return this.wrapped.unwrap(clazz);
        }

        @Override
        public Logger getParentLogger() {
            return null;
        }
    }
}

