/*
 * Decompiled with CFR 0.152.
 */
package play.data.validation;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.metadata.ConstraintDescriptor;
import play.data.Form;
import play.libs.F;

public class Constraints {
    public static List<F.Tuple<String, List<Object>>> displayableConstraint(Set<ConstraintDescriptor<?>> set2) {
        ArrayList<F.Tuple<String, List<Object>>> arrayList = new ArrayList<F.Tuple<String, List<Object>>>();
        for (ConstraintDescriptor<?> constraintDescriptor : set2) {
            Class<? extends Annotation> clazz = constraintDescriptor.getAnnotation().annotationType();
            if (!clazz.isAnnotationPresent(Form.Display.class)) continue;
            Form.Display display = clazz.getAnnotation(Form.Display.class);
            String string2 = display.name();
            ArrayList arrayList2 = new ArrayList();
            Map map2 = constraintDescriptor.getAttributes();
            for (String string3 : display.attributes()) {
                arrayList2.add(map2.get(string3));
            }
            arrayList.add(F.Tuple(string2, arrayList2));
        }
        return arrayList;
    }

    public static Validator<Object> required() {
        return new RequiredValidator();
    }

    public static Validator<Number> min(long l) {
        return new MinValidator(l);
    }

    public static Validator<Number> max(long l) {
        return new MaxValidator(l);
    }

    public static Validator<String> minLength(long l) {
        return new MinLengthValidator(l);
    }

    public static Validator<String> maxLength(long l) {
        return new MaxLengthValidator(l);
    }

    public static Validator<String> email() {
        return new EmailValidator();
    }

    public static Validator<String> pattern(String string2) {
        return new PatternValidator(string2);
    }

    public static class PatternValidator
    extends Validator<String>
    implements ConstraintValidator<Pattern, String> {
        public static final String message = "error.pattern";
        java.util.regex.Pattern regex = null;

        public PatternValidator() {
        }

        public PatternValidator(String string2) {
            this.regex = java.util.regex.Pattern.compile(string2);
        }

        public void initialize(Pattern pattern2) {
            this.regex = java.util.regex.Pattern.compile(pattern2.value());
        }

        @Override
        public boolean isValid(String string2) {
            if (string2 == null || string2.length() == 0) {
                return true;
            }
            return this.regex.matcher(string2).matches();
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={PatternValidator.class})
    @Form.Display(name="constraint.pattern", attributes={})
    public static @interface Pattern {
        public String message() default "error.email";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public String value();
    }

    public static class EmailValidator
    extends Validator<String>
    implements ConstraintValidator<Email, String> {
        public static final String message = "error.email";
        static final java.util.regex.Pattern regex = java.util.regex.Pattern.compile("\\b[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}\\b");

        public void initialize(Email email) {
        }

        @Override
        public boolean isValid(String string2) {
            if (string2 == null || string2.length() == 0) {
                return true;
            }
            return regex.matcher(string2).matches();
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={EmailValidator.class})
    @Form.Display(name="constraint.email", attributes={})
    public static @interface Email {
        public String message() default "error.email";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static class MaxLengthValidator
    extends Validator<String>
    implements ConstraintValidator<MaxLength, String> {
        public static final String message = "error.maxLength";
        private long max;

        public MaxLengthValidator() {
        }

        public MaxLengthValidator(long l) {
            this.max = l;
        }

        public void initialize(MaxLength maxLength2) {
            this.max = maxLength2.value();
        }

        @Override
        public boolean isValid(String string2) {
            if (string2 == null || string2.length() == 0) {
                return true;
            }
            return (long)string2.length() <= this.max;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MaxLengthValidator.class})
    @Form.Display(name="constraint.maxLength", attributes={"value"})
    public static @interface MaxLength {
        public String message() default "error.maxLength";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();
    }

    public static class MinLengthValidator
    extends Validator<String>
    implements ConstraintValidator<MinLength, String> {
        public static final String message = "error.minLength";
        private long min;

        public MinLengthValidator() {
        }

        public MinLengthValidator(long l) {
            this.min = l;
        }

        public void initialize(MinLength minLength2) {
            this.min = minLength2.value();
        }

        @Override
        public boolean isValid(String string2) {
            if (string2 == null || string2.length() == 0) {
                return true;
            }
            return (long)string2.length() >= this.min;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MinLengthValidator.class})
    @Form.Display(name="constraint.minLength", attributes={"value"})
    public static @interface MinLength {
        public String message() default "error.minLength";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();
    }

    public static class MaxValidator
    extends Validator<Number>
    implements ConstraintValidator<Max, Number> {
        public static final String message = "error.max";
        private long max;

        public MaxValidator() {
        }

        public MaxValidator(long l) {
            this.max = l;
        }

        public void initialize(Max max2) {
            this.max = max2.value();
        }

        @Override
        public boolean isValid(Number number) {
            if (number == null) {
                return true;
            }
            return number.longValue() <= this.max;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MaxValidator.class})
    @Form.Display(name="constraint.max", attributes={"value"})
    public static @interface Max {
        public String message() default "error.max";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();
    }

    public static class MinValidator
    extends Validator<Number>
    implements ConstraintValidator<Min, Number> {
        public static final String message = "error.min";
        private long min;

        public MinValidator() {
        }

        public MinValidator(long l) {
            this.min = l;
        }

        public void initialize(Min min2) {
            this.min = min2.value();
        }

        @Override
        public boolean isValid(Number number) {
            if (number == null) {
                return true;
            }
            return number.longValue() >= this.min;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MinValidator.class})
    @Form.Display(name="constraint.min", attributes={"value"})
    public static @interface Min {
        public String message() default "error.min";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();
    }

    public static class RequiredValidator
    extends Validator<Object>
    implements ConstraintValidator<Required, Object> {
        public static final String message = "error.required";

        public void initialize(Required required) {
        }

        @Override
        public boolean isValid(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof String) {
                return !((String)object).isEmpty();
            }
            if (object instanceof Collection) {
                return !((Collection)object).isEmpty();
            }
            return true;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={RequiredValidator.class})
    @Form.Display(name="constraint.required")
    public static @interface Required {
        public String message() default "error.required";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static abstract class Validator<T> {
        public abstract boolean isValid(T var1);

        public boolean isValid(T t, ConstraintValidatorContext constraintValidatorContext) {
            return this.isValid(t);
        }
    }
}

