/*
 * Decompiled with CFR 0.152.
 */
package play.data;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.metadata.PropertyDescriptor;
import org.codehaus.jackson.JsonNode;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.convert.ConversionService;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.FieldError;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import play.api.data.FormUtils;
import play.api.libs.json.Json;
import play.data.format.Formatters;
import play.data.validation.Constraints;
import play.data.validation.Validation;
import play.data.validation.ValidationError;
import play.i18n.Lang;
import play.i18n.Messages;
import play.libs.F;
import play.libs.Scala;
import play.mvc.Controller;
import play.mvc.Http;

public class Form<T> {
    private final String rootName;
    private final Class<T> backedType;
    private final Map<String, String> data;
    private final Map<String, List<ValidationError>> errors;
    private final F.Option<T> value;

    private T blankInstance() {
        try {
            return this.backedType.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot instantiate " + this.backedType + ". It must have a default constructor", exception);
        }
    }

    public Form(Class<T> clazz) {
        this(null, clazz);
    }

    public Form(String string2, Class<T> clazz) {
        this(string2, clazz, new HashMap<String, String>(), new HashMap<String, List<ValidationError>>(), F.None());
    }

    public Form(String string2, Class<T> clazz, Map<String, String> map2, Map<String, List<ValidationError>> map3, F.Option<T> option) {
        this.rootName = string2;
        this.backedType = clazz;
        this.data = map2;
        this.errors = map3;
        this.value = option;
    }

    protected Map<String, String> requestData() {
        String[] stringArray;
        Map<Object, Object> map2 = new HashMap();
        if (Controller.request().body().asFormUrlEncoded() != null) {
            map2 = Controller.request().body().asFormUrlEncoded();
        }
        Map<Object, Object> map3 = new HashMap();
        if (Controller.request().body().asMultipartFormData() != null) {
            map3 = Controller.request().body().asMultipartFormData().asFormUrlEncoded();
        }
        Map<Object, Object> map4 = new HashMap();
        if (Controller.request().body().asJson() != null) {
            map4 = Scala.asJava(FormUtils.fromJson("", Json.parse(play.libs.Json.stringify(Controller.request().body().asJson()))));
        }
        Map<String, String[]> map5 = Controller.request().queryString();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : map2.keySet()) {
            stringArray = (String[])map2.get(string2);
            if (stringArray.length <= 0) continue;
            hashMap.put(string2, stringArray[0]);
        }
        for (String string2 : map3.keySet()) {
            stringArray = (String[])map3.get(string2);
            if (stringArray.length <= 0) continue;
            hashMap.put(string2, stringArray[0]);
        }
        for (String string3 : map4.keySet()) {
            hashMap.put(string3, (String)map4.get(string3));
        }
        for (String string4 : map5.keySet()) {
            stringArray = map5.get(string4);
            if (stringArray.length <= 0) continue;
            hashMap.put(string4, stringArray[0]);
        }
        return hashMap;
    }

    public Form<T> bindFromRequest(String ... stringArray) {
        return this.bind(this.requestData(), stringArray);
    }

    public Form<T> bind(JsonNode jsonNode, String ... stringArray) {
        return this.bind(Scala.asJava(FormUtils.fromJson("", Json.parse(play.libs.Json.stringify(jsonNode)))), stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public Form<T> bind(Map<String, String> map2, String ... stringArray) {
        void var6_10;
        Object object;
        DataBinder dataBinder = null;
        Map<String, String> map3 = map2;
        if (this.rootName == null) {
            dataBinder = new DataBinder(this.blankInstance());
        } else {
            dataBinder = new DataBinder(this.blankInstance(), this.rootName);
            map3 = new HashMap<String, String>();
            for (String object22 : map2.keySet()) {
                if (!object22.startsWith(this.rootName + ".")) continue;
                map3.put(object22.substring(this.rootName.length() + 1), map2.get(object22));
            }
        }
        if (stringArray.length > 0) {
            dataBinder.setAllowedFields(stringArray);
        }
        dataBinder.setValidator((Validator)new SpringValidatorAdapter(Validation.getValidator()));
        dataBinder.setConversionService((ConversionService)Formatters.conversion);
        dataBinder.setAutoGrowNestedPaths(true);
        dataBinder.bind((PropertyValues)new MutablePropertyValues(map3));
        dataBinder.validate();
        BindingResult bindingResult = dataBinder.getBindingResult();
        if (bindingResult.hasErrors()) {
            HashMap<String, List<ValidationError>> hashMap = new HashMap<String, List<ValidationError>>();
            for (FieldError fieldError : bindingResult.getFieldErrors()) {
                String string2 = fieldError.getObjectName() + "." + fieldError.getField();
                if (string2.startsWith("target.") && this.rootName == null) {
                    string2 = string2.substring(7);
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object object2 : fieldError.getArguments()) {
                    if (object2 instanceof DefaultMessageSourceResolvable) continue;
                    arrayList.add(object2);
                }
                if (!hashMap.containsKey(string2)) {
                    hashMap.put(string2, new ArrayList());
                }
                ((List)hashMap.get(string2)).add(new ValidationError(string2, fieldError.isBindingFailure() ? "error.invalid" : fieldError.getDefaultMessage(), arrayList));
            }
            return new Form<T>(this.rootName, this.backedType, map2, hashMap, F.None());
        }
        Object var6_8 = null;
        if (bindingResult.getTarget() != null) {
            try {
                object = bindingResult.getTarget().getClass().getMethod("validate", new Class[0]);
                Object object3 = ((Method)object).invoke(bindingResult.getTarget(), new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        if (var6_10 != null) {
            object = new HashMap();
            if (var6_10 instanceof String) {
                object.put("", new ArrayList());
                ((List)object.get("")).add(new ValidationError("", (String)var6_10, new ArrayList<Object>()));
            } else if (var6_10 instanceof List) {
                object.put("", (List)var6_10);
            } else if (var6_10 instanceof Map) {
                object = (Map)var6_10;
            }
            return new Form<T>(this.rootName, this.backedType, map2, (Map<String, List<ValidationError>>)object, F.None());
        }
        return new Form<Object>(this.rootName, this.backedType, new HashMap<String, String>(map2), new HashMap<String, List<ValidationError>>(this.errors), F.Some(bindingResult.getTarget()));
    }

    public Map<String, String> data() {
        return this.data;
    }

    public String name() {
        return this.rootName;
    }

    public F.Option<T> value() {
        return this.value;
    }

    public Form<T> fill(T t) {
        if (t == null) {
            throw new RuntimeException("Cannot fill a form with a null value");
        }
        return new Form<T>(this.rootName, this.backedType, new HashMap<String, String>(), new HashMap<String, List<ValidationError>>(), F.Some(t));
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasGlobalErrors() {
        return this.errors.containsKey("") && !this.errors.get("").isEmpty();
    }

    public List<ValidationError> globalErrors() {
        List<ValidationError> list = this.errors.get("");
        if (list == null) {
            list = new ArrayList<ValidationError>();
        }
        return list;
    }

    public ValidationError globalError() {
        List<ValidationError> list = this.globalErrors();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public Map<String, List<ValidationError>> errors() {
        return this.errors;
    }

    public ValidationError error(String string2) {
        List<ValidationError> list = this.errors.get(string2);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public JsonNode errorsAsJson() {
        return this.errorsAsJson(Http.Context.Implicit.lang());
    }

    public JsonNode errorsAsJson(Lang lang2) {
        HashMap hashMap = new HashMap();
        for (String string2 : this.errors.keySet()) {
            List<ValidationError> list = this.errors.get(string2);
            if (list == null || list.isEmpty()) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ValidationError validationError : list) {
                arrayList.add(Messages.get(lang2, validationError.message(), validationError.arguments()));
            }
            hashMap.put(string2, arrayList);
        }
        return play.libs.Json.toJson(hashMap);
    }

    public T get() {
        return this.value.get();
    }

    public void reject(ValidationError validationError) {
        if (!this.errors.containsKey(validationError.key())) {
            this.errors.put(validationError.key(), new ArrayList());
        }
        this.errors.get(validationError.key()).add(validationError);
    }

    public void reject(String string2, String string3, List<Object> list) {
        this.reject(new ValidationError(string2, string3, list));
    }

    public void reject(String string2, String string3) {
        this.reject(string2, string3, new ArrayList<Object>());
    }

    public void reject(String string2, List<Object> list) {
        this.reject(new ValidationError("", string2, list));
    }

    public void reject(String string2) {
        this.reject("", string2, new ArrayList<Object>());
    }

    public Field apply(String string2) {
        return this.field(string2);
    }

    public Field field(String string2) {
        Object object;
        Object object2;
        Object object3;
        String string3 = null;
        if (this.data.containsKey(string2)) {
            string3 = this.data.get(string2);
        } else if (this.value.isDefined()) {
            object3 = new BeanWrapperImpl(this.value.get());
            object3.setAutoGrowNestedPaths(true);
            object2 = string2;
            if (this.rootName != null && string2.startsWith(this.rootName + ".")) {
                object2 = string2.substring(this.rootName.length() + 1);
            }
            if (object3.isReadableProperty((String)object2) && (object = object3.getPropertyValue((String)object2)) != null) {
                string3 = Formatters.print(object3.getPropertyTypeDescriptor((String)object2), object);
            }
        }
        object3 = this.errors.get(string2);
        if (object3 == null) {
            object3 = new ArrayList();
        }
        object2 = null;
        object = new BeanWrapperImpl(this.blankInstance());
        object.setAutoGrowNestedPaths(true);
        try {
            for (PropertyDescriptor propertyDescriptor : object.getPropertyTypeDescriptor(string2).getAnnotations()) {
                Display display;
                Class<? extends Annotation> clazz = propertyDescriptor.annotationType();
                if (!clazz.isAnnotationPresent(Display.class) || !(display = clazz.getAnnotation(Display.class)).name().startsWith("format.")) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (String string4 : display.attributes()) {
                    Object object4 = null;
                    try {
                        object4 = propertyDescriptor.getClass().getDeclaredMethod(string4, new Class[0]).invoke((Object)propertyDescriptor, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList.add(object4);
                }
                object2 = F.Tuple(display.name(), arrayList);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        PropertyDescriptor propertyDescriptor = Validation.getValidator().getConstraintsForClass(this.backedType).getConstraintsForProperty(string2);
        ArrayList<F.Tuple<String, List<Object>>> arrayList = new ArrayList();
        if (propertyDescriptor != null) {
            arrayList = Constraints.displayableConstraint(propertyDescriptor.getConstraintDescriptors());
        }
        return new Field(this, string2, arrayList, (F.Tuple<String, List<Object>>)object2, (List<ValidationError>)object3, string3);
    }

    public String toString() {
        return "Form(of=" + this.backedType + ", data=" + this.data + ", value=" + this.value + ", errors=" + this.errors + ")";
    }

    public static class Field {
        private final Form<?> form;
        private final String name;
        private final List<F.Tuple<String, List<Object>>> constraints;
        private final F.Tuple<String, List<Object>> format;
        private final List<ValidationError> errors;
        private final String value;

        public Field(Form<?> form2, String string2, List<F.Tuple<String, List<Object>>> list, F.Tuple<String, List<Object>> tuple2, List<ValidationError> list2, String string3) {
            this.form = form2;
            this.name = string2;
            this.constraints = list;
            this.format = tuple2;
            this.errors = list2;
            this.value = string3;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public String valueOr(String string2) {
            if (this.value == null) {
                return string2;
            }
            return this.value;
        }

        public List<ValidationError> errors() {
            return this.errors;
        }

        public List<F.Tuple<String, List<Object>>> constraints() {
            return this.constraints;
        }

        public F.Tuple<String, List<Object>> format() {
            return this.format;
        }

        public List<Integer> indexes() {
            ArrayList<Integer> arrayList;
            block4: {
                block3: {
                    Object object;
                    arrayList = new ArrayList<Integer>();
                    if (!this.form.value().isDefined()) break block3;
                    BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(this.form.value().get());
                    beanWrapperImpl.setAutoGrowNestedPaths(true);
                    String string2 = this.name;
                    if (this.form.name() != null && this.name.startsWith(this.form.name() + ".")) {
                        string2 = this.name.substring(this.form.name().length() + 1);
                    }
                    if (!beanWrapperImpl.isReadableProperty(string2) || !((object = beanWrapperImpl.getPropertyValue(string2)) instanceof Collection)) break block4;
                    for (int i = 0; i < ((Collection)object).size(); ++i) {
                        arrayList.add(i);
                    }
                    break block4;
                }
                Pattern pattern2 = Pattern.compile("^" + Pattern.quote(this.name) + "\\[(\\d+)\\].*$");
                for (String string3 : this.form.data().keySet()) {
                    Matcher matcher = pattern2.matcher(string3);
                    if (!matcher.matches()) continue;
                    arrayList.add(Integer.parseInt(matcher.group(1)));
                }
            }
            return arrayList;
        }

        public Field sub(String string2) {
            String string3 = null;
            string3 = string2.startsWith("[") ? this.name + string2 : this.name + "." + string2;
            return this.form.field(string3);
        }

        public String toString() {
            return "Form.Field(" + this.name + ")";
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.ANNOTATION_TYPE})
    public static @interface Display {
        public String name();

        public String[] attributes() default {};
    }
}

