/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.openid;

import java.net.URLEncoder;
import play.api.http.ContentTypeOf$;
import play.api.http.HeaderNames$;
import play.api.http.Writeable$;
import play.api.libs.concurrent.Promise;
import play.api.libs.concurrent.PurePromise$;
import play.api.libs.openid.Errors$AUTH_ERROR$;
import play.api.libs.openid.Errors$BAD_RESPONSE$;
import play.api.libs.openid.Errors$NETWORK_ERROR$;
import play.api.libs.openid.OpenID$;
import play.api.libs.openid.OpenID$$anonfun$play$api$libs$openid$OpenID$$discoverServer$1$;
import play.api.libs.openid.OpenIDServer;
import play.api.libs.openid.UserInfo;
import play.api.libs.openid.UserInfo$;
import play.api.libs.ws.Response;
import play.api.libs.ws.WS$;
import play.api.mvc.Codec$;
import play.api.mvc.Request;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenID$
implements ScalaObject {
    public static final OpenID$ MODULE$;
    private final Regex play$api$libs$openid$OpenID$$providerRegex;
    private final Regex play$api$libs$openid$OpenID$$serverRegex;
    private final Regex play$api$libs$openid$OpenID$$localidRegex;
    private final Regex play$api$libs$openid$OpenID$$delegateRegex;

    static {
        new OpenID$();
    }

    public Promise<String> redirectURL(String openID, String callbackURL$1, Seq<Tuple2<String, String>> axRequired$1, Seq<Tuple2<String, String>> axOptional$1) {
        String claimedId$1 = this.normalize(openID);
        return this.play$api$libs$openid$OpenID$$discoverServer(claimedId$1).map(new Serializable(callbackURL$1, axRequired$1, axOptional$1, claimedId$1){
            public static final long serialVersionUID;
            private final String callbackURL$1;
            private final Seq axRequired$1;
            private final Seq axOptional$1;
            public final String claimedId$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(OpenIDServer server) {
                Seq parameters2 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"openid.ns").$minus$greater((Object)"http://specs.openid.net/auth/2.0"), Predef$.MODULE$.any2ArrowAssoc((Object)"openid.mode").$minus$greater((Object)"checkid_setup"), Predef$.MODULE$.any2ArrowAssoc((Object)"openid.claimed_id").$minus$greater((Object)this.claimedId$1), Predef$.MODULE$.any2ArrowAssoc((Object)"openid.identity").$minus$greater(server.delegate().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID;
                    private final anonfun.redirectURL.1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return this.$outer.claimedId$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })), Predef$.MODULE$.any2ArrowAssoc((Object)"openid.return_to").$minus$greater((Object)this.callbackURL$1)}))).$plus$plus(OpenID$.MODULE$.play$api$libs$openid$OpenID$$axParameters((Seq<Tuple2<String, String>>)this.axRequired$1, (Seq<Tuple2<String, String>>)this.axOptional$1), Seq$.MODULE$.canBuildFrom());
                String separator = server.url().contains("?") ? "&" : "?";
                return new StringBuilder().append((Object)server.url()).append((Object)separator).append((Object)((TraversableOnce)parameters2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply(Tuple2<String, String> pair2) {
                        return new StringBuilder().append((Object)((String)pair2._1())).append((Object)"=").append((Object)URLEncoder.encode((String)pair2._2(), "UTF-8")).toString();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString("&")).toString();
            }
            {
                this.callbackURL$1 = string2;
                this.axRequired$1 = seq2;
                this.axOptional$1 = seq3;
                this.claimedId$1 = string3;
            }
        });
    }

    public Seq redirectURL$default$4() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Seq redirectURL$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Promise<UserInfo> verifiedId(Request<?> request) {
        return this.verifiedId(request.queryString());
    }

    public Promise<UserInfo> verifiedId(java.util.Map<String, String[]> queryString2) {
        return this.verifiedId((Map<String, Seq<String>>)JavaConversions$.MODULE$.mapAsScalaMap(queryString2).toMap(Predef$.MODULE$.conforms()).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Seq<String> apply(String[] stringArray) {
                return Predef$.MODULE$.refArrayOps((Object[])stringArray).toSeq();
            }
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Promise<UserInfo> verifiedId(Map<String, Seq<String>> queryString$1) {
        Promise<UserInfo> promise;
        Tuple3 tuple3 = new Tuple3((Object)queryString$1.get((Object)"openid.mode").flatMap((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<String> apply(Seq<String> seq2) {
                return seq2.headOption();
            }
        }), (Object)queryString$1.get((Object)"openid.claimed_id").flatMap((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<String> apply(Seq<String> seq2) {
                return seq2.headOption();
            }
        }).orElse((Function0)new Serializable(queryString$1){
            public static final long serialVersionUID;
            private final Map queryString$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<String> apply() {
                return this.queryString$1.get((Object)"openid.identity").flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Option<String> apply(Seq<String> seq2) {
                        return seq2.headOption();
                    }
                });
            }
            {
                this.queryString$1 = map2;
            }
        }), (Object)queryString$1.get((Object)"openid.op_endpoint").flatMap((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<String> apply(Seq<String> seq2) {
                return seq2.headOption();
            }
        }));
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            Option option3 = (Option)tuple3._3();
            if (option instanceof Some) {
                Object object = ((Some)option).x();
                String string2 = "id_res";
                if (!(object != null ? !object.equals(string2) : string2 != null) && option2 instanceof Some) {
                    String string3;
                    Some some = (Some)option2;
                    String id$2 = string3 = (String)some.x();
                    Option endPoint = option3;
                    Promise server = (Promise)endPoint.map((Function1)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Promise<String> apply(String string2) {
                            return PurePromise$.MODULE$.apply(new Serializable(this, string2){
                                public static final long serialVersionUID;
                                private final String x$11$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return this.x$11$1;
                                }
                                {
                                    this.x$11$1 = string2;
                                }
                            });
                        }
                    }).getOrElse((Function0)new Serializable(id$2){
                        public static final long serialVersionUID;
                        private final String id$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Promise<String> apply() {
                            return OpenID$.MODULE$.play$api$libs$openid$OpenID$$discoverServer(this.id$2).map(new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply(OpenIDServer openIDServer) {
                                    return openIDServer.url();
                                }
                            });
                        }
                        {
                            this.id$2 = string2;
                        }
                    });
                    promise = server.flatMap(new Serializable(queryString$1){
                        public static final long serialVersionUID;
                        public final Map queryString$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Promise<UserInfo> apply(String url) {
                            Map fields = ((Map)this.queryString$1.$minus((Object)"openid.mode")).$plus(Predef$.MODULE$.any2ArrowAssoc((Object)"openid.mode").$minus$greater((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"check_authentication"})))).mapValues((Function1)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Seq<String> apply(Seq<String> seq2) {
                                    return (Seq)seq2.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply(String string2) {
                                            return URLEncoder.encode(string2, "UTF-8");
                                        }
                                    }, Seq$.MODULE$.canBuildFrom());
                                }
                            });
                            return WS$.MODULE$.url(url).post(fields, Writeable$.MODULE$.writeableOf_urlEncodedForm(Codec$.MODULE$.utf_8()), ContentTypeOf$.MODULE$.contentTypeOf_urlEncodedForm(Codec$.MODULE$.utf_8())).map(new Serializable(this){
                                public static final long serialVersionUID;
                                private final anonfun.verifiedId.6 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final UserInfo apply(Response response) {
                                    if (response.status() == 200 && response.body().contains("is_valid:true")) {
                                        return UserInfo$.MODULE$.apply((Map<String, Seq<String>>)this.$outer.queryString$1);
                                    }
                                    throw Errors$AUTH_ERROR$.MODULE$;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        {
                            this.queryString$1 = map2;
                        }
                    });
                    return promise;
                }
            }
        }
        promise = PurePromise$.MODULE$.apply(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Nothing$ apply() {
                throw Errors$BAD_RESPONSE$.MODULE$;
            }
        });
        return promise;
    }

    public final Seq<Tuple2<String, String>> play$api$libs$openid$OpenID$$axParameters(Seq<Tuple2<String, String>> axRequired, Seq<Tuple2<String, String>> axOptional) {
        Nil$ nil$;
        if (axRequired.length() == 0 && axOptional.length() == 0) {
            nil$ = Nil$.MODULE$;
        } else {
            Nil$ axRequiredParams = axRequired.size() == 0 ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"openid.ax.required").$minus$greater((Object)((TraversableOnce)axRequired.map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Tuple2<String, String> tuple2) {
                    return (String)tuple2._1();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(","))}));
            Nil$ axOptionalParams = axOptional.size() == 0 ? Nil$.MODULE$ : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"openid.ax.if_available").$minus$greater((Object)((TraversableOnce)axOptional.map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Tuple2<String, String> tuple2) {
                    return (String)tuple2._1();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(","))}));
            Seq definitions = (Seq)((TraversableLike)axRequired.$plus$plus(axOptional, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Tuple2<String, String> apply(Tuple2<String, String> attribute) {
                    return Predef$.MODULE$.any2ArrowAssoc((Object)new StringBuilder().append((Object)"openid.ax.type.").append(attribute._1()).toString()).$minus$greater(attribute._2());
                }
            }, Seq$.MODULE$.canBuildFrom());
            nil$ = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)"openid.ns.ax").$minus$greater((Object)"http://openid.net/srv/ax/1.0"), Predef$.MODULE$.any2ArrowAssoc((Object)"openid.ax.mode").$minus$greater((Object)"fetch_request")}))).$plus$plus((GenTraversableOnce)axRequiredParams, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)axOptionalParams, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)definitions, Seq$.MODULE$.canBuildFrom());
        }
        return nil$;
    }

    private String normalize(String openID) {
        String trimmed = openID.trim();
        return trimmed.startsWith("http://") || trimmed.startsWith("https://") ? trimmed : new StringBuilder().append((Object)"http://").append((Object)trimmed).toString();
    }

    public final Regex play$api$libs$openid$OpenID$$providerRegex() {
        return this.play$api$libs$openid$OpenID$$providerRegex;
    }

    public final Regex play$api$libs$openid$OpenID$$serverRegex() {
        return this.play$api$libs$openid$OpenID$$serverRegex;
    }

    public final Regex play$api$libs$openid$OpenID$$localidRegex() {
        return this.play$api$libs$openid$OpenID$$localidRegex;
    }

    public final Regex play$api$libs$openid$OpenID$$delegateRegex() {
        return this.play$api$libs$openid$OpenID$$delegateRegex;
    }

    public final Promise<OpenIDServer> play$api$libs$openid$OpenID$$discoverServer(String openid) {
        return WS$.MODULE$.url(openid).get().map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final OpenIDServer apply(Response response$1) {
                Option serverUrl = OpenID$.MODULE$.play$api$libs$openid$OpenID$$providerRegex().findFirstIn((CharSequence)response$1.body()).orElse((Function0)new Serializable(this, response$1){
                    public static final long serialVersionUID;
                    private final Response response$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Option<String> apply() {
                        return OpenID$.MODULE$.play$api$libs$openid$OpenID$$serverRegex().findFirstIn((CharSequence)this.response$1.body());
                    }
                    {
                        this.response$1 = response;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Option<String> apply(String string2) {
                        return OpenID$.MODULE$.play$api$libs$openid$OpenID$$extractHref(string2);
                    }
                });
                Option fromHtml = serverUrl.map((Function1)new Serializable(this, response$1){
                    public static final long serialVersionUID;
                    public final Response response$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final OpenIDServer apply(String url) {
                        Option delegate = OpenID$.MODULE$.play$api$libs$openid$OpenID$$localidRegex().findFirstIn((CharSequence)this.response$1.body()).orElse((Function0)new Serializable(this){
                            public static final long serialVersionUID;
                            private final anonfun$play$api$libs$openid$OpenID$$discoverServer$1$$anonfun$12 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Option<String> apply() {
                                return OpenID$.MODULE$.play$api$libs$openid$OpenID$$delegateRegex().findFirstIn((CharSequence)this.$outer.response$1.body());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Option<String> apply(String string2) {
                                return OpenID$.MODULE$.play$api$libs$openid$OpenID$$extractHref(string2);
                            }
                        });
                        return new OpenIDServer(url, (Option<String>)delegate);
                    }
                    {
                        this.response$1 = response;
                    }
                });
                Option fromXRD$1 = response$1.header(HeaderNames$.MODULE$.CONTENT_TYPE()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(String string2) {
                        return string2.contains("application/xrds+xml");
                    }
                }).map((Function1)new Serializable(this, response$1){
                    public static final long serialVersionUID;
                    private final Response response$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final OpenIDServer apply(String x$20) {
                        return new OpenIDServer(this.response$1.xml().$bslash$bslash("URI").text(), (Option<String>)None$.MODULE$);
                    }
                    {
                        this.response$1 = response;
                    }
                });
                return (OpenIDServer)fromHtml.orElse((Function0)new Serializable(this, fromXRD$1){
                    public static final long serialVersionUID;
                    private final Option fromXRD$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Option<OpenIDServer> apply() {
                        return this.fromXRD$1;
                    }
                    {
                        this.fromXRD$1 = option;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Nothing$ apply() {
                        throw Errors$NETWORK_ERROR$.MODULE$;
                    }
                });
            }
        });
    }

    public final Option<String> play$api$libs$openid$OpenID$$extractHref(String link$1) {
        return new Regex("href=\"([^\"]*)\"", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).findFirstMatchIn((CharSequence)link$1).map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(Regex.Match match) {
                return match.group(1).trim();
            }
        }).orElse((Function0)new Serializable(link$1){
            public static final long serialVersionUID;
            private final String link$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<String> apply() {
                return new Regex("href='([^']*)'", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).findFirstMatchIn((CharSequence)this.link$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply(Regex.Match match) {
                        return match.group(1).trim();
                    }
                });
            }
            {
                this.link$1 = string2;
            }
        });
    }

    private OpenID$() {
        MODULE$ = this;
        this.play$api$libs$openid$OpenID$$providerRegex = new Regex("<link[^>]+openid2[.]provider[^>]+>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.play$api$libs$openid$OpenID$$serverRegex = new Regex("<link[^>]+openid[.]server[^>]+>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.play$api$libs$openid$OpenID$$localidRegex = new Regex("<link[^>]+openid2[.]local_id[^>]+>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.play$api$libs$openid$OpenID$$delegateRegex = new Regex("<link[^>]+openid[.]delegate[^>]+>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }
}

