/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ResolveStatus;
import java.util.IdentityHashMap;
import java.util.Map;

final class SubstitutionResolver {
    private final AbstractConfigObject root;
    private final Map<AbstractConfigValue, AbstractConfigValue> memos;

    SubstitutionResolver(AbstractConfigObject abstractConfigObject) {
        this.root = abstractConfigObject;
        this.memos = new IdentityHashMap<AbstractConfigValue, AbstractConfigValue>();
    }

    AbstractConfigValue resolve(AbstractConfigValue abstractConfigValue, int n, ConfigResolveOptions configResolveOptions) {
        if (this.memos.containsKey(abstractConfigValue)) {
            return this.memos.get(abstractConfigValue);
        }
        AbstractConfigValue abstractConfigValue2 = abstractConfigValue.resolveSubstitutions(this, n, configResolveOptions);
        if (abstractConfigValue2 != null && abstractConfigValue2.resolveStatus() != ResolveStatus.RESOLVED) {
            throw new ConfigException.BugOrBroken("resolveSubstitutions() did not give us a resolved object");
        }
        this.memos.put(abstractConfigValue, abstractConfigValue2);
        return abstractConfigValue2;
    }

    AbstractConfigObject root() {
        return this.root;
    }

    static AbstractConfigValue resolve(AbstractConfigValue abstractConfigValue, AbstractConfigObject abstractConfigObject, ConfigResolveOptions configResolveOptions) {
        SubstitutionResolver substitutionResolver = new SubstitutionResolver(abstractConfigObject);
        return substitutionResolver.resolve(abstractConfigValue, 0, configResolveOptions);
    }
}

