/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValueType;
import com.typesafe.config.impl.ConfigNumber;

final class ConfigDouble
extends ConfigNumber {
    private static final long serialVersionUID = 1L;
    private final double value;

    ConfigDouble(ConfigOrigin configOrigin, double d, String string) {
        super(configOrigin, string);
        this.value = d;
    }

    @Override
    public ConfigValueType valueType() {
        return ConfigValueType.NUMBER;
    }

    @Override
    public Double unwrapped() {
        return this.value;
    }

    @Override
    String transformToString() {
        String string = super.transformToString();
        if (string == null) {
            return Double.toString(this.value);
        }
        return string;
    }

    @Override
    protected long longValue() {
        return (long)this.value;
    }

    @Override
    protected double doubleValue() {
        return this.value;
    }

    @Override
    protected ConfigDouble newCopy(boolean bl, ConfigOrigin configOrigin) {
        return new ConfigDouble(configOrigin, this.value, this.originalText);
    }
}

