/*
 * Decompiled with CFR 0.152.
 */
package scalax.file.ramfs;

import java.net.URI;
import java.util.regex.Pattern;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scalax.file.BasicPathSet;
import scalax.file.LinkOption;
import scalax.file.NotDirectoryException;
import scalax.file.Path;
import scalax.file.Path$;
import scalax.file.Path$AccessModes$Execute$;
import scalax.file.Path$AccessModes$Read$;
import scalax.file.Path$AccessModes$Write$;
import scalax.file.PathMatcher;
import scalax.file.PathMatcherFactory;
import scalax.file.ramfs.DirNode;
import scalax.file.ramfs.DirNode$;
import scalax.file.ramfs.FileNode;
import scalax.file.ramfs.FileNode$;
import scalax.file.ramfs.Node;
import scalax.file.ramfs.RamFileOps;
import scalax.file.ramfs.RamFileOps$class;
import scalax.file.ramfs.RamFileSystem;
import scalax.file.ramfs.RamPath$;
import scalax.file.ramfs.RamPath$$anonfun$descendants$1$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0001\u0003\u0001%\u0011qAU1n!\u0006$\bN\u0003\u0002\u0004\t\u0005)!/Y7gg*\u0011QAB\u0001\u0005M&dWMC\u0001\b\u0003\u0019\u00198-\u00197bq\u000e\u00011\u0003\u0002\u0001\u000b\u001dI\u0001\"a\u0003\u0007\u000e\u0003\u0011I!!\u0004\u0003\u0003\tA\u000bG\u000f\u001b\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011!BU1n\r&dWm\u00149t!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011e\u0001!\u0011!Q\u0001\ni\t!B]3mCRLg/\u001a+p!\tYbD\u0004\u0002\u00149%\u0011Q\u0004F\u0001\u0007!J,G-\u001a4\n\u0005}\u0001#AB*ue&twM\u0003\u0002\u001e)!A!\u0005\u0001BC\u0002\u0013\u00051%\u0001\u0003qCRDW#\u0001\u000e\t\u0011\u0015\u0002!\u0011!Q\u0001\ni\tQ\u0001]1uQ\u0002B\u0001b\n\u0001\u0003\u0006\u0004%\t\u0005K\u0001\u000bM&dWmU=ti\u0016lW#A\u0015\u0011\u0005=Q\u0013BA\u0016\u0003\u00055\u0011\u0016-\u001c$jY\u0016\u001c\u0016p\u001d;f[\"IQ\u0006\u0001B\u0001B\u0003%\u0011FL\u0001\fM&dWmU=ti\u0016l\u0007%\u0003\u0002(\u0019!)\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"BAM\u001a5kA\u0011q\u0002\u0001\u0005\u00063=\u0002\rA\u0007\u0005\u0006E=\u0002\rA\u0007\u0005\u0006O=\u0002\r!\u000b\u0005\u0006o\u0001!\t\u0001O\u0001\u0005]>$W-F\u0001:!\r\u0019\"\bP\u0005\u0003wQ\u0011aa\u00149uS>t\u0007CA\b>\u0013\tq$A\u0001\u0003O_\u0012,\u0007\u0002\u0003!\u0001\u0011\u000b\u0007I\u0011A!\u0002\u0015Q|\u0017IY:pYV$X-F\u00013\u0011!\u0019\u0005\u0001#A!B\u0013\u0011\u0014a\u0003;p\u0003\n\u001cx\u000e\\;uK\u0002B\u0001\"\u0012\u0001\t\u0006\u0004%\tAR\u0001\u0006i>,&+S\u000b\u0002\u000fB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0004]\u0016$(\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u00131!\u0016*J\u0011!\u0001\u0006\u0001#A!B\u00139\u0015A\u0002;p+JK\u0005\u0005C\u0003S\u0001\u0011\u00051+\u0001\u0003%I&4HC\u0001\u001aU\u0011\u0015)\u0016\u000b1\u0001\u001b\u0003\u0015\u0019\u0007.\u001b7e\u0011!9\u0006\u0001#b\u0001\n\u0003\u0019\u0013\u0001\u00028b[\u0016D\u0001\"\u0017\u0001\t\u0002\u0003\u0006KAG\u0001\u0006]\u0006lW\r\t\u0005\u00067\u0002!\t\u0001X\u0001\u000bi>\u0014V-\u00197QCRDGCA/d!\tq\u0016M\u0004\u0002`M9\u0011\u0001mP\u0007\u0002\u0001%\u0011!M\u000b\u0002\t!\u0006$\b\u000eV=qK\")AM\u0017a\u0001K\u0006YA.\u001b8l\u001fB$\u0018n\u001c8t!\r\u0019b\r[\u0005\u0003OR\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\tY\u0011.\u0003\u0002k\t\tQA*\u001b8l\u001fB$\u0018n\u001c8\t\u00111\u0004\u0001R1A\u0005\u00025\fa\u0001]1sK:$X#\u00018\u0011\u0007MQ$\u0007\u0003\u0005q\u0001!\u0005\t\u0015)\u0003o\u0003\u001d\u0001\u0018M]3oi\u0002BQA\u001d\u0001\u0005\u0002M\f1b\u00195fG.\f5mY3tgR\u0011Ao\u001e\t\u0003'UL!A\u001e\u000b\u0003\u000f\t{w\u000e\\3b]\")\u00010\u001da\u0001s\u0006)Qn\u001c3fgB\u00191C\u001a>\u0011\u0007m\f)A\u0004\u0002}\u007f:\u00111\"`\u0005\u0003}\u0012\tA\u0001U1uQ&!\u0011\u0011AA\u0002\u0003-\t5mY3tg6{G-Z:\u000b\u0005y$\u0011\u0002BA\u0004\u0003\u0013\u0011!\"Q2dKN\u001cXj\u001c3f\u0015\u0011\t\t!a\u0001\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010\u00051Q\r_5tiN,\u0012\u0001\u001e\u0005\b\u0003'\u0001A\u0011AA\b\u0003\u0019I7OR5mK\"9\u0011q\u0003\u0001\u0005\u0002\u0005=\u0011aC5t\t&\u0014Xm\u0019;pefDq!a\u0007\u0001\t\u0003\ty!\u0001\u0006jg\u0006\u00137o\u001c7vi\u0016Dq!a\b\u0001\t\u0003\ty!\u0001\u0005jg\"KG\rZ3o\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K\tA\u0002\\1ti6{G-\u001b4jK\u0012,\"!a\n\u0011\u0007M\tI#C\u0002\u0002,Q\u0011A\u0001T8oO\"9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0012\u0001\u00057bgRlu\u000eZ5gS\u0016$w\fJ3r)\u0011\t9#a\r\t\u0011\u0005U\u0012Q\u0006a\u0001\u0003O\tA\u0001^5nK\"9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0012\u0001B:ju\u0016,\"!!\u0010\u0011\tMQ\u0014q\u0005\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0003)\t7mY3tg~#S-\u001d\u000b\u0005\u0003\u000b\nY\u0005E\u0002\u0014\u0003\u000fJ1!!\u0013\u0015\u0005\u0011)f.\u001b;\t\u0011\u00055\u0013q\ba\u0001\u0003\u001f\n1\"Y2dKN\u001cXj\u001c3fgB)\u0011\u0011KA1u:!\u00111KA/\u001d\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-\u0011\u00051AH]8pizJ\u0011!F\u0005\u0004\u0003?\"\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003G\n)G\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\ty\u0006\u0006\u0005\b\u0003S\u0002A\u0011AA6\u00031!wn\u0011:fCR,g)\u001b7f)\u0005!\bbBA8\u0001\u0011\u0005\u00111N\u0001\u0012I>\u001c%/Z1uK\u0012K'/Z2u_JL\bbBA:\u0001\u0011\u0005\u0011QO\u0001\u0010I>\u001c%/Z1uKB\u000b'/\u001a8ugR\u0011\u0011Q\t\u0005\b\u0003s\u0002A\u0011AA>\u0003\u0019!W\r\\3uKR\u0019\u0001-! \t\u0013\u0005}\u0014q\u000fI\u0001\u0002\u0004!\u0018!\u00024pe\u000e,\u0007bBAB\u0001\u0011E\u0011QQ\u0001\t[>4XMR5mKR1\u0011QIAD\u0003\u0017Cq!!#\u0002\u0002\u0002\u0007!\"\u0001\u0004uCJ<W\r\u001e\u0005\b\u0003\u001b\u000b\t\t1\u0001u\u0003)\tGo\\7jG6{g/\u001a\u0005\b\u0003#\u0003A\u0011CAJ\u00035iwN^3ESJ,7\r^8ssR1\u0011QIAK\u0003/Cq!!#\u0002\u0010\u0002\u0007!\u0002C\u0004\u0002\u000e\u0006=\u0005\u0019\u0001;\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\u0006AAo\\*ue&tw\rF\u0001\u001b\u0011\u001d\t\t\u000b\u0001C\u0001\u0003G\u000b1\u0002Z3tG\u0016tG-\u00198ugV1\u0011QUAt\u0003{#\u0002\"a*\u0002P\u0006M\u0017Q\u001c\u000b\u0005\u0003S\u000by\u000b\u0005\u0003\f\u0003W\u0013\u0014bAAW\t\ta!)Y:jGB\u000bG\u000f[*fi\"A\u0011\u0011WAP\u0001\b\t\u0019,A\u0004gC\u000e$xN]=\u0011\u000b-\t),!/\n\u0007\u0005]FA\u0001\nQCRDW*\u0019;dQ\u0016\u0014h)Y2u_JL\b\u0003BA^\u0003{c\u0001\u0001\u0002\u0005\u0002@\u0006}%\u0019AAa\u0005\u00051\u0015\u0003BAb\u0003\u0013\u00042aEAc\u0013\r\t9\r\u0006\u0002\b\u001d>$\b.\u001b8h!\r\u0019\u00121Z\u0005\u0004\u0003\u001b$\"aA!os\"Q\u0011\u0011[AP!\u0003\u0005\r!!/\u0002\r\u0019LG\u000e^3s\u0011)\t).a(\u0011\u0002\u0003\u0007\u0011q[\u0001\u0006I\u0016\u0004H\u000f\u001b\t\u0004'\u0005e\u0017bAAn)\t\u0019\u0011J\u001c;\t\u0015\u0005}\u0017q\u0014I\u0001\u0002\u0004\t\t/A\u0004paRLwN\\:\u0011\u000b\u0005E\u00131\u001d5\n\t\u0005\u0015\u0018Q\r\u0002\f)J\fg/\u001a:tC\ndW\r\u0002\u0005\u0002j\u0006}%\u0019AAv\u0005\u0005)\u0016c\u0001\u0006\u0002J\u0002")
public class RamPath
extends Path
implements RamFileOps,
ScalaObject {
    private final String relativeTo;
    private final String path;
    private RamPath toAbsolute;
    private URI toURI;
    private String name;
    private Option<RamPath> parent;

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public RamFileSystem fileSystem() {
        return (RamFileSystem)super.fileSystem();
    }

    public Option<Node> node() {
        return this.fileSystem().lookup(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RamPath toAbsolute() {
        if ((this.bitmap$0 & 0x20) != 0) return this.toAbsolute;
        RamPath ramPath = this;
        synchronized (ramPath) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.toAbsolute = this.fileSystem().fromStrings("", new StringBuilder().append((Object)this.relativeTo).append((Object)this.separator()).append((Object)this.path()).toString());
                this.bitmap$0 = this.bitmap$0 | 0x20;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.toAbsolute;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public URI toURI() {
        if ((this.bitmap$0 & 0x40) != 0) return this.toURI;
        RamPath ramPath = this;
        synchronized (ramPath) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.toURI = this.fileSystem().uri(this);
                this.bitmap$0 = this.bitmap$0 | 0x40;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.toURI;
        }
    }

    @Override
    public RamPath $div(String child) {
        this.fileSystem().checkSegmentForSeparators(child);
        return this.fileSystem().fromStrings(this.relativeTo, new StringBuilder().append((Object)this.path()).append((Object)this.separator()).append((Object)child).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String name() {
        if ((this.bitmap$0 & 0x80) != 0) return this.name;
        RamPath ramPath = this;
        synchronized (ramPath) {
            if ((this.bitmap$0 & 0x80) == 0) {
                Object[] objectArray = this.path().split(Pattern.quote(this.separator()));
                Option $inlThis1 = new ArrayOps.ofRef(objectArray).lastOption();
                this.name = (String)(!$inlThis1.isEmpty() ? $inlThis1.get() : this.path());
                this.bitmap$0 = this.bitmap$0 | 0x80;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.name;
        }
    }

    @Override
    public RamPath toRealPath(Seq<LinkOption> linkOptions) {
        return (RamPath)this.toAbsolute().normalize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<RamPath> parent() {
        if ((this.bitmap$0 & 0x100) != 0) return this.parent;
        RamPath ramPath = this;
        synchronized (ramPath) {
            if ((this.bitmap$0 & 0x100) == 0) {
                List list;
                Object v11;
                String x$21;
                boolean bl;
                Object[] objectArray = this.path().split(Pattern.quote(this.separator()));
                List raw = new ArrayOps.ofRef(objectArray).toList();
                List noEmpty = (List)raw.filterNot((Function1)new $anonfun$1(this));
                Option $inlThis1 = raw.headOption();
                if (!$inlThis1.isEmpty() && (bl = (x$21 = (String)(v11 = $inlThis1.get())).isEmpty())) {
                    String string = this.separator();
                    list = (List)noEmpty.$plus$colon((Object)string, List$.MODULE$.canBuildFrom());
                } else {
                    list = noEmpty;
                }
                List segs = list;
                List list2 = (List)segs.dropRight(1);
                Nil$ nil$ = Nil$.MODULE$;
                List list3 = list2;
                this.parent = !(nil$ != null ? !nil$.equals(list3) : list3 != null) ? None$.MODULE$ : new Some((Object)this.fileSystem().apply(this.relativeTo, (Seq<String>)list2));
                this.bitmap$0 = this.bitmap$0 | 0x100;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.parent;
        }
    }

    @Override
    public boolean checkAccess(Seq<Path.AccessModes.AccessMode> modes) {
        Option<Node> option;
        block4: {
            boolean bl;
            block3: {
                Node node;
                block2: {
                    option = this.node();
                    None$ none$ = None$.MODULE$;
                    Option<Node> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    bl = false;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Node node$1 = node = (Node)some.x();
                bl = modes.forall((Function1)new Serializable(this, node$1){
                    public static final long serialVersionUID;
                    public final Node node$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Path.AccessModes.AccessMode accessMode) {
                        Path.AccessModes.AccessMode accessMode2;
                        block5: {
                            boolean bl;
                            block3: {
                                block4: {
                                    block2: {
                                        accessMode2 = accessMode;
                                        Path$AccessModes$Execute$ path$AccessModes$Execute$ = Path$AccessModes$Execute$.MODULE$;
                                        Path.AccessModes.AccessMode accessMode3 = accessMode2;
                                        if (path$AccessModes$Execute$ != null ? !path$AccessModes$Execute$.equals(accessMode3) : accessMode3 != null) break block2;
                                        bl = this.node$1.canExecute();
                                        break block3;
                                    }
                                    Path$AccessModes$Read$ path$AccessModes$Read$ = Path$AccessModes$Read$.MODULE$;
                                    Path.AccessModes.AccessMode accessMode4 = accessMode2;
                                    if (path$AccessModes$Read$ != null ? !path$AccessModes$Read$.equals(accessMode4) : accessMode4 != null) break block4;
                                    bl = this.node$1.canRead();
                                    break block3;
                                }
                                Path$AccessModes$Write$ path$AccessModes$Write$ = Path$AccessModes$Write$.MODULE$;
                                Path.AccessModes.AccessMode accessMode5 = accessMode2;
                                if (path$AccessModes$Write$ != null ? !path$AccessModes$Write$.equals(accessMode5) : accessMode5 != null) break block5;
                                bl = this.node$1.canWrite();
                            }
                            return bl;
                        }
                        throw new MatchError((Object)accessMode2);
                    }
                    {
                        this.node$1 = node;
                    }
                });
            }
            return bl;
        }
        throw new MatchError(option);
    }

    @Override
    public boolean exists() {
        return this.node().isDefined();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isFile() {
        void $inlThis3;
        void $inlThis1;
        Option<Node> option = this.node();
        None$ none$ = !option.isEmpty() ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)((Node)$inlThis1.get() instanceof FileNode))) : None$.MODULE$;
        return BoxesRunTime.unboxToBoolean((Object)(!none$.isEmpty() ? $inlThis3.get() : BoxesRunTime.boxToBoolean((boolean)false)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isDirectory() {
        void $inlThis3;
        void $inlThis1;
        Option<Node> option = this.node();
        None$ none$ = !option.isEmpty() ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)((Node)$inlThis1.get() instanceof DirNode))) : None$.MODULE$;
        return BoxesRunTime.unboxToBoolean((Object)(!none$.isEmpty() ? $inlThis3.get() : BoxesRunTime.boxToBoolean((boolean)false)));
    }

    @Override
    public boolean isAbsolute() {
        String string = this.relativeTo;
        return !(string != null ? !string.equals("") : "" != null);
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long lastModified() {
        void $inlThis3;
        void $inlThis1;
        Option<Node> option = this.node();
        None$ none$ = !option.isEmpty() ? new Some((Object)BoxesRunTime.boxToLong((long)((Node)$inlThis1.get()).lastModified())) : None$.MODULE$;
        return BoxesRunTime.unboxToLong((Object)(!none$.isEmpty() ? $inlThis3.get() : BoxesRunTime.boxToLong((long)0L)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long lastModified_$eq(long time$1) {
        Option<Node> option = this.node();
        if (!option.isEmpty()) {
            void $inlThis1;
            ((Node)$inlThis1.get()).lastModified_$eq(time$1);
        }
        return time$1;
    }

    @Override
    public Option<Object> size() {
        return this.node().collect(new PartialFunction(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply(Node node) {
                Node node2 = node;
                if (node2 instanceof FileNode) {
                    return ((FileNode)node2).data().size();
                }
                throw new MatchError((Object)node2);
            }

            public final boolean isDefinedAt(Node node) {
                Node node2 = node;
                return node2 instanceof FileNode;
            }
            {
                Function1.class.$init$((Function1)this);
                PartialFunction.class.$init$((PartialFunction)this);
            }
        });
    }

    @Override
    public void access_$eq(Iterable<Path.AccessModes.AccessMode> accessModes) {
        Option<Node> option = this.node();
        None$ none$ = None$.MODULE$;
        Option<Node> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw Path$.MODULE$.fail(Predef$.MODULE$.augmentString("Path %s does not exist").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})));
        }
        if (option instanceof Some) {
            Node node;
            Some some = (Some)option;
            Node node2 = node = (Node)some.x();
            node2.canRead_$eq(accessModes.exists((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Path.AccessModes.AccessMode accessMode) {
                    Path.AccessModes.AccessMode accessMode2 = accessMode;
                    Path$AccessModes$Read$ path$AccessModes$Read$ = Path$AccessModes$Read$.MODULE$;
                    return !(accessMode2 != null ? !accessMode2.equals(path$AccessModes$Read$) : path$AccessModes$Read$ != null);
                }
            }));
            node2.canWrite_$eq(accessModes.exists((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Path.AccessModes.AccessMode accessMode) {
                    Path.AccessModes.AccessMode accessMode2 = accessMode;
                    Path$AccessModes$Write$ path$AccessModes$Write$ = Path$AccessModes$Write$.MODULE$;
                    return !(accessMode2 != null ? !accessMode2.equals(path$AccessModes$Write$) : path$AccessModes$Write$ != null);
                }
            }));
            node2.canExecute_$eq(accessModes.exists((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Path.AccessModes.AccessMode accessMode) {
                    Path.AccessModes.AccessMode accessMode2 = accessMode;
                    Path$AccessModes$Execute$ path$AccessModes$Execute$ = Path$AccessModes$Execute$.MODULE$;
                    return !(accessMode2 != null ? !accessMode2.equals(path$AccessModes$Execute$) : path$AccessModes$Execute$ != null);
                }
            }));
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public boolean doCreateFile() {
        return this.fileSystem().create(this, FileNode$.MODULE$, false);
    }

    @Override
    public boolean doCreateDirectory() {
        return this.fileSystem().create(this, DirNode$.MODULE$, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doCreateParents() {
        Option<RamPath> option = this.toAbsolute().parent();
        if (!option.isEmpty()) {
            void $inlThis1;
            RamPath ramPath = (RamPath)$inlThis1.get();
            this.fileSystem().create(ramPath, DirNode$.MODULE$, true);
        }
    }

    @Override
    public RamPath delete(boolean force) {
        this.node();
        if (Option$.MODULE$.option2Iterable(this.node()).forall((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Node n) {
                return n instanceof FileNode || ((DirNode)n).children().isEmpty();
            }
        })) {
            if (this.exists() && !this.fileSystem().delete(this, force)) {
                throw Path$.MODULE$.fail(new StringBuilder().append((Object)"Could not delete ").append((Object)this.path()).toString());
            }
            return this;
        }
        throw Path$.MODULE$.fail("Directory is not empty, cannot delete");
    }

    @Override
    public void moveFile(Path target, boolean atomicMove) {
        this.fileSystem().move(this, (RamPath)target);
    }

    @Override
    public void moveDirectory(Path target, boolean atomicMove) {
        this.fileSystem().move(this, (RamPath)target);
    }

    @Override
    public String toString() {
        return Predef$.MODULE$.augmentString("RamPath(%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()}));
    }

    public <U, F> BasicPathSet<RamPath> descendants(F filter, int depth, Traversable<LinkOption> options, PathMatcherFactory<F> factory) {
        if (this.isDirectory()) {
            return new BasicPathSet<RamPath>(this, (PathMatcher<RamPath>)((PathMatcher)factory.apply(filter)), depth, false, (Function2<PathMatcher<RamPath>, RamPath, Iterator<RamPath>>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Iterator<RamPath> apply(PathMatcher<RamPath> pathFilter, RamPath parent$1) {
                    return ((TraversableLike)Option$.MODULE$.option2Iterable(parent$1.node().collect(new PartialFunction(this, parent$1){
                        public static final long serialVersionUID;
                        public final RamPath parent$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final ArrayBuffer<RamPath> apply(Node node) {
                            Node node2 = node;
                            if (node2 instanceof DirNode) {
                                return (ArrayBuffer)((DirNode)node2).children().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID;
                                    public final $anonfun$descendants$1$$anonfun$apply$1 $outer;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final RamPath apply(Node n) {
                                        return this.$outer.parent$1.$div(n.name());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, ArrayBuffer$.MODULE$.canBuildFrom());
                            }
                            throw new NotDirectoryException(Predef$.MODULE$.any2stringadd((Object)node2).$plus(" is not a directory so descendants can not be called on it"));
                        }

                        public final boolean isDefinedAt(Node node) {
                            return true;
                        }
                        {
                            this.parent$1 = ramPath;
                            Function1.class.$init$((Function1)this);
                            PartialFunction.class.$init$((PartialFunction)this);
                        }
                    })).flatten((Function1)Predef$.MODULE$.conforms())).toIterator();
                }
            });
        }
        throw new NotDirectoryException(Predef$.MODULE$.any2stringadd((Object)this).$plus(" is not a directory so descendants can not be called on it"));
    }

    public RamPath(String relativeTo, String path, RamFileSystem fileSystem) {
        this.relativeTo = relativeTo;
        this.path = path;
        super(fileSystem);
        RamFileOps$class.$init$(this);
    }
}

