/*
 * Decompiled with CFR 0.152.
 */
package scalax.file.ramfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URLStreamHandler;
import java.util.UUID;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scalax.file.FileSystem;
import scalax.file.Path;
import scalax.file.ramfs.DirNode;
import scalax.file.ramfs.DirNode$;
import scalax.file.ramfs.FileNode;
import scalax.file.ramfs.FileNode$;
import scalax.file.ramfs.Handler$;
import scalax.file.ramfs.Node;
import scalax.file.ramfs.NodeFac;
import scalax.file.ramfs.RamFileSystem$;
import scalax.file.ramfs.RamPath;
import scalax.io.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\rUr!B\u0001\u0003\u0011\u000bI\u0011!\u0004*b[\u001aKG.Z*zgR,WN\u0003\u0002\u0004\t\u0005)!/Y7gg*\u0011QAB\u0001\u0005M&dWMC\u0001\b\u0003\u0019\u00198-\u00197bq\u000e\u0001\u0001C\u0001\u0006\f\u001b\u0005\u0011a!\u0002\u0007\u0003\u0011\u000bi!!\u0004*b[\u001aKG.Z*zgR,WnE\u0002\f\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\u001e\u0017\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013\u0019!\u0001e\u0003!\"\u0005\u001d\u0011\u0016-\u001c$t\u0013\u0012\u001cRa\b\b\u0017E\u0015\u0002\"aF\u0012\n\u0005\u0011B\"a\u0002)s_\u0012,8\r\u001e\t\u0003/\u0019J!a\n\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011%z\"Q3A\u0005\u0002)\n!!\u001b3\u0016\u0003-\u0002\"\u0001L\u0018\u000f\u0005]i\u0013B\u0001\u0018\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001'\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059B\u0002\u0002C\u001a \u0005#\u0005\u000b\u0011B\u0016\u0002\u0007%$\u0007\u0005C\u0003\u001e?\u0011\u0005Q\u0007\u0006\u00027qA\u0011qgH\u0007\u0002\u0017!9\u0011\u0006\u000eI\u0001\u0002\u0004Y\u0003b\u0002\u001e \u0003\u0003%\taO\u0001\u0005G>\u0004\u0018\u0010\u0006\u00027y!9\u0011&\u000fI\u0001\u0002\u0004Y\u0003b\u0002  #\u0003%\taP\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\u0001%FA\u0016BW\u0005\u0011\u0005CA\"I\u001b\u0005!%BA#G\u0003%)hn\u00195fG.,GM\u0003\u0002H1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005%#%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\")1j\bC!\u0019\u0006A\u0001.Y:i\u0007>$W\rF\u0001N!\t9b*\u0003\u0002P1\t\u0019\u0011J\u001c;\t\u000bE{B\u0011\t*\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u000b\u0005\u0006)~!\t%V\u0001\u0007KF,\u0018\r\\:\u0015\u0005YK\u0006CA\fX\u0013\tA\u0006DA\u0004C_>dW-\u00198\t\u000fi\u001b\u0016\u0011!a\u00017\u0006\u0019\u0001\u0010J\u0019\u0011\u0005]a\u0016BA/\u0019\u0005\r\te.\u001f\u0005\u0006?~!\t\u0005Y\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003\u0005\u0004\"a\u00042\n\u0005A\u0002\u0002\"\u00023 \t\u0003*\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#A'\t\u000b\u001d|B\u0011\t5\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00111,\u001b\u0005\b5\u001a\f\t\u00111\u0001N\u0011\u0015Yw\u0004\"\u0011m\u0003!\u0019\u0017M\\#rk\u0006dGC\u0001,n\u0011\u001dQ&.!AA\u0002m;qa\\\u0006\u0002\u0002#\u0015\u0001/A\u0004SC645/\u00133\u0011\u0005]\nha\u0002\u0011\f\u0003\u0003E)A]\n\u0005cN4R\u0005\u0005\u0003uo.2T\"A;\u000b\u0005YD\u0012a\u0002:v]RLW.Z\u0005\u0003qV\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82\u0011\u0015i\u0012\u000f\"\u0001{)\u0005\u0001\b\"B)r\t\u000bbH#A1\t\u000fy\f\u0018\u0011!CA\u007f\u0006)\u0011\r\u001d9msR\u0019a'!\u0001\t\u000f%j\b\u0013!a\u0001W!I\u0011QA9\u0002\u0002\u0013\u0005\u0015qA\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tI!a\u0004\u0011\t]\tYaK\u0005\u0004\u0003\u001bA\"AB(qi&|g\u000eC\u0004\u0002\u0012\u0005\r\u0001\u0019\u0001\u001c\u0002\u0007a$\u0003\u0007\u0003\u0005\u0002\u0016E\f\n\u0011\"\u0001@\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\n\u0004\u0002CA\rcF\u0005I\u0011A \u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%c!9\u0011QD9\u0005\u0012\u0005}\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012A\u0004\u0005\t\u0003GY!\u0019!C\u0001A\u0006A\u0001O]8u_\u000e|G\u000eC\u0004\u0002(-\u0001\u000b\u0011B1\u0002\u0013A\u0014x\u000e^8d_2\u0004\u0003\"CA\u0016\u0017\t\u0007I\u0011BA\u0017\u0003-1\u0017\u000e\\3TsN$X-\\:\u0016\u0005\u0005=\u0002cBA\u0019\u0003w1\u0014qH\u0007\u0003\u0003gQA!!\u000e\u00028\u00059Q.\u001e;bE2,'bAA\u001d1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00121\u0007\u0002\f/\u0016\f7\u000eS1tQ6\u000b\u0007\u000fE\u0002\u000b\u0003\u00032Q\u0001\u0004\u0002\u0001\u0003\u0007\u001aR!!\u0011\u0002FY\u0001B!a\u0012\u0002J5\tA!C\u0002\u0002L\u0011\u0011!BR5mKNK8\u000f^3n\u0011)I\u0013\u0011\tBC\u0002\u0013\u0005\u0011qJ\u000b\u0003\u0003#\u00022!a\u0015 \u001d\tQ\u0001\u0001\u0003\u00064\u0003\u0003\u0012\t\u0011)A\u0005\u0003#B!\"!\u0017\u0002B\t\u0015\r\u0011\"\u0001+\u0003%\u0019X\r]1sCR|'\u000f\u0003\u0006\u0002^\u0005\u0005#\u0011!Q\u0001\n-\n!b]3qCJ\fGo\u001c:!\u0011-\t\t'!\u0011\u0003\u0006\u0004%\t!a\u0019\u0002\u000f\r|g\u000e^3yiV\u0011\u0011Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111\u000e\u0004\u0002\u0005%|\u0017\u0002BA8\u0003S\u0012qBU3t_V\u00148-Z\"p]R,\u0007\u0010\u001e\u0005\f\u0003g\n\tE!A!\u0002\u0013\t)'\u0001\u0005d_:$X\r\u001f;!\u0011\u001di\u0012\u0011\tC\u0001\u0003o\"\u0002\"a\u0010\u0002z\u0005m\u0014Q\u0010\u0005\nS\u0005U\u0004\u0013!a\u0001\u0003#B\u0011\"!\u0017\u0002vA\u0005\t\u0019A\u0016\t\u0015\u0005\u0005\u0014Q\u000fI\u0001\u0002\u0004\t)'B\u0004\u0002\u0002\u0006\u0005\u0003!a!\u0003\u0011A\u000bG\u000f\u001b+za\u0016\u00042ACAC\u0013\r\t9I\u0001\u0002\b%\u0006l\u0007+\u0019;i\u0011)\tY)!\u0011A\u0002\u0013%\u0011QR\u0001\u0007MN$&/Z3\u0016\u0005\u0005=\u0005c\u0001\u0006\u0002\u0012&\u0019\u00111\u0013\u0002\u0003\u000f\u0011K'OT8eK\"Q\u0011qSA!\u0001\u0004%I!!'\u0002\u0015\u0019\u001cHK]3f?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0006\u0005\u0006cA\f\u0002\u001e&\u0019\u0011q\u0014\r\u0003\tUs\u0017\u000e\u001e\u0005\n5\u0006U\u0015\u0011!a\u0001\u0003\u001fC\u0011\"!*\u0002B\u0001\u0006K!a$\u0002\u000f\u0019\u001cHK]3fA!Q\u0011\u0011VA!\u0005\u0004%\t!a+\u0002\tI|w\u000e^\u000b\u0003\u0003\u0007C\u0011\"a,\u0002B\u0001\u0006I!a!\u0002\u000bI|w\u000e\u001e\u0011\t\u0015\u0005M\u0016\u0011\ta\u0001\n\u0003\tY+A\u0002qo\u0012D!\"a.\u0002B\u0001\u0007I\u0011AA]\u0003\u001d\u0001x\u000fZ0%KF$B!a'\u0002<\"I!,!.\u0002\u0002\u0003\u0007\u00111\u0011\u0005\n\u0003\u007f\u000b\t\u0005)Q\u0005\u0003\u0007\u000bA\u0001]<eA!I\u00111YA!\u0005\u0004%\t\u0001Y\u0001\u0005]\u0006lW\r\u0003\u0005\u0002H\u0006\u0005\u0003\u0015!\u0003b\u0003\u0015q\u0017-\\3!\u0011-\tY-!\u0011\t\u0006\u0004%\t%!4\u0002!U\u0014Hn\u0015;sK\u0006l\u0007*\u00198eY\u0016\u0014XCAAh!\u00159\u00121BAi!\u0011\t\u0019.!7\u000e\u0005\u0005U'bAAl%\u0005\u0019a.\u001a;\n\t\u0005m\u0017Q\u001b\u0002\u0011+Jc5\u000b\u001e:fC6D\u0015M\u001c3mKJD1\"a8\u0002B!\u0005\t\u0015)\u0003\u0002P\u0006\tRO\u001d7TiJ,\u0017-\u001c%b]\u0012dWM\u001d\u0011\t\u0011\u0005\r\u0018\u0011\tC!\u0003K\f!B\u001a:p[N#(/\u001b8h)\u0011\t\u0019)a:\t\u000f\u0005%\u0018\u0011\u001da\u0001W\u0005!\u0001/\u0019;i\u0011!\ti/!\u0011\u0005\u0012\u0005=\u0018a\u00043p\u0007J,\u0017\r^3Ge>l7+Z9\u0015\t\u0005\r\u0015\u0011\u001f\u0005\t\u0003g\fY\u000f1\u0001\u0002v\u0006A1/Z4nK:$8\u000fE\u0003\u0002x\n\u001d1F\u0004\u0003\u0002z\n\ra\u0002BA~\u0005\u0003i!!!@\u000b\u0007\u0005}\b\"\u0001\u0004=e>|GOP\u0005\u00023%\u0019!Q\u0001\r\u0002\u000fA\f7m[1hK&!!\u0011\u0002B\u0006\u0005\r\u0019V-\u001d\u0006\u0004\u0005\u000bA\u0002b\u0002@\u0002B\u0011\u0005!q\u0002\u000b\u0007\u0003\u0007\u0013\tB!\u0006\t\u000f\tM!Q\u0002a\u0001W\u0005Q!/\u001a7bi&4X\rV8\t\u0011\u0005M(Q\u0002a\u0001\u0003kD\u0011B!\u0007\u0002B\u0011E!Aa\u0007\u0002\u0017\u0019\u0014x.\\*ue&twm\u001d\u000b\u0007\u0003\u0007\u0013iBa\b\t\u000f\tM!q\u0003a\u0001W!9\u0011\u0011\u001eB\f\u0001\u0004Y\u0003\u0002\u0003B\u0012\u0003\u0003\"\tE!\n\u0002\u000bI|w\u000e^:\u0016\u0005\t\u001d\u0002#\u0002\u0017\u0003*\u0005\r\u0015b\u0001B\u0016c\t\u00191+\u001a;\t\u0011\t=\u0012\u0011\tC\u0001\u0005c\tQ\"\u001e9eCR,7i\u001c8uKb$H\u0003BA \u0005gA\u0001B!\u000e\u0003.\u0001\u0007\u0011QM\u0001\u000b]\u0016<8i\u001c8uKb$\b\u0002\u0003B\u0018\u0003\u0003\"\tE!\u000f\u0015\t\u0005}\"1\b\u0005\t\u0005{\u00119\u00041\u0001\u0003@\u0005\ta\rE\u0004\u0018\u0005\u0003\n)'!\u001a\n\u0007\t\r\u0003DA\u0005Gk:\u001cG/[8oc!A!qIA!\t\u0003\u0011I%\u0001\bde\u0016\fG/\u001a+f[B4\u0015\u000e\\3\u0015\u0015\u0005\r%1\nB(\u0005'\u00129\u0006C\u0005\u0003N\t\u0015\u0003\u0013!a\u0001W\u00051\u0001O]3gSbD\u0011B!\u0015\u0003FA\u0005\t\u0019A\u0016\u0002\rM,hMZ5y\u0011%\u0011)F!\u0012\u0011\u0002\u0003\u00071&A\u0002eSJD\u0011B!\u0017\u0003FA\u0005\t\u0019\u0001,\u0002\u0019\u0011,G.\u001a;f\u001f:,\u00050\u001b;\t\u0011\tu\u0013\u0011\tC\u0001\u0005?\n1c\u0019:fCR,G+Z7q\t&\u0014Xm\u0019;pef$\"\"a!\u0003b\t\r$Q\rB4\u0011%\u0011iEa\u0017\u0011\u0002\u0003\u00071\u0006C\u0005\u0003R\tm\u0003\u0013!a\u0001W!I!Q\u000bB.!\u0003\u0005\ra\u000b\u0005\n\u00053\u0012Y\u0006%AA\u0002YC\u0001Ba\u001b\u0002B\u0011\u0005!QN\u0001\u0004kJLG\u0003\u0002B8\u0005k\u0002B!a5\u0003r%!!1OAk\u0005\r)&+\u0013\u0005\u000b\u0003S\u0014I\u0007%AA\u0002\u0005\r\u0005BB)\u0002B\u0011\u0005C\u0010C\u0005\u0003|\u0005\u0005C\u0011\u0001\u0002\u0003~\u00051An\\8lkB$BAa \u0003\bB)q#a\u0003\u0003\u0002B\u0019!Ba!\n\u0007\t\u0015%A\u0001\u0003O_\u0012,\u0007\u0002CAu\u0005s\u0002\r!a!\t\u0013\t-\u0015\u0011\tC\u0001\u0005\t5\u0015AB2sK\u0006$X\rF\u0004W\u0005\u001f\u0013\tJa'\t\u0011\u0005%(\u0011\u0012a\u0001\u0003\u0007C\u0001Ba%\u0003\n\u0002\u0007!QS\u0001\u0004M\u0006\u001c\u0007c\u0001\u0006\u0003\u0018&\u0019!\u0011\u0014\u0002\u0003\u000f9{G-\u001a$bG\"I!Q\u0014BE!\u0003\u0005\rAV\u0001\u000eGJ,\u0017\r^3QCJ,g\u000e^:\t\u0013\t\u0005\u0016\u0011\tC\u0001\u0005\t\r\u0016A\u00023fY\u0016$X\rF\u0003W\u0005K\u00139\u000b\u0003\u0005\u0002j\n}\u0005\u0019AAB\u0011\u001d\u0011IKa(A\u0002Y\u000bQAZ8sG\u0016D\u0011B!,\u0002B\u0011\u0005!Aa,\u0002\t5|g/\u001a\u000b\u0006-\nE&Q\u0017\u0005\t\u0005g\u0013Y\u000b1\u0001\u0002\u0004\u0006\u00191O]2\t\u0011\t]&1\u0016a\u0001\u0003\u0007\u000bA\u0001Z3ti\"I!1XA!\t\u0003\u0011!QX\u0001\tG>\u0004\u0018PR5mKRA\u00111\u0014B`\u0005\u0003\u0014Y\r\u0003\u0005\u00034\ne\u0006\u0019AAB\u0011!\u0011\u0019M!/A\u0002\t\u0015\u0017aB:sG:{G-\u001a\t\u0004\u0015\t\u001d\u0017b\u0001Be\u0005\tAa)\u001b7f\u001d>$W\r\u0003\u0005\u00038\ne\u0006\u0019AAB\u0011%\u0011y-!\u0011\u0012\u0002\u0013\u0005s(\u0001\rde\u0016\fG/\u001a+f[B4\u0015\u000e\\3%I\u00164\u0017-\u001e7uIEB\u0011Ba5\u0002BE\u0005I\u0011I \u00021\r\u0014X-\u0019;f)\u0016l\u0007OR5mK\u0012\"WMZ1vYR$#\u0007C\u0005\u0003X\u0006\u0005\u0013\u0013!C!\u007f\u0005A2M]3bi\u0016$V-\u001c9GS2,G\u0005Z3gCVdG\u000fJ\u001a\t\u0015\tm\u0017\u0011II\u0001\n\u0003\u0012i.\u0001\rde\u0016\fG/\u001a+f[B4\u0015\u000e\\3%I\u00164\u0017-\u001e7uIQ*\"Aa8+\u0005Y\u000b\u0005\"\u0003Br\u0003\u0003\n\n\u0011\"\u0011@\u0003u\u0019'/Z1uKR+W\u000e\u001d#je\u0016\u001cGo\u001c:zI\u0011,g-Y;mi\u0012\n\u0004\"\u0003Bt\u0003\u0003\n\n\u0011\"\u0011@\u0003u\u0019'/Z1uKR+W\u000e\u001d#je\u0016\u001cGo\u001c:zI\u0011,g-Y;mi\u0012\u0012\u0004\"\u0003Bv\u0003\u0003\n\n\u0011\"\u0011@\u0003u\u0019'/Z1uKR+W\u000e\u001d#je\u0016\u001cGo\u001c:zI\u0011,g-Y;mi\u0012\u001a\u0004B\u0003Bx\u0003\u0003\n\n\u0011\"\u0011\u0003^\u0006i2M]3bi\u0016$V-\u001c9ESJ,7\r^8ss\u0012\"WMZ1vYR$C\u0007\u0003\u0006\u0003t\u0006\u0005\u0013\u0013!C\u0001\u0005k\fQ\"\u001e:jI\u0011,g-Y;mi\u0012\nTC\u0001B|U\r\t\u0019)\u0011\u0005\u000b\u0005w\f\t%%A\u0005\u0002\tu\u0017\u0001E2sK\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00134\u0011!\u0011yp\u0003Q\u0001\n\u0005=\u0012\u0001\u00044jY\u0016\u001c\u0016p\u001d;f[N\u0004\u0003B\u0002@\f\t\u0003\u0019\u0019\u0001\u0006\u0003\u0002@\r\u0015\u0001\"CA-\u0007\u0003\u0001\n\u00111\u0001,\u0011\u0019q8\u0002\"\u0001\u0004\nQ!\u0011qHB\u0006\u0011\u001d\u0019iaa\u0002A\u0002Y\nAAZ:JI\"1ap\u0003C\u0001\u0007#!B!a!\u0004\u0014!A!1NB\b\u0001\u0004\u0011y\u0007C\u0004\u0004\u0018-!Ia!\u0007\u0002\u0011I,w-[:uKJ$b!a'\u0004\u001c\ru\u0001bBB\u0007\u0007+\u0001\rA\u000e\u0005\t\u0007?\u0019)\u00021\u0001\u0002@\u0005\u0011am\u001d\u0005\t\u0003+Y\u0011\u0013!C\u0001\u007f!I\u0011\u0011D\u0006\u0012\u0002\u0013\u00051QE\u000b\u0003\u0007OQ3!!\u0015B\u0011!\u0019YcCI\u0001\n\u0003y\u0014AD5oSR$C-\u001a4bk2$HE\r\u0005\n\u0007_Y\u0011\u0013!C\u0001\u0007c\ta\"\u001b8ji\u0012\"WMZ1vYR$3'\u0006\u0002\u00044)\u001a\u0011QM!")
public class RamFileSystem
extends FileSystem
implements ScalaObject {
    private final RamFsId id;
    private final String separator;
    private final ResourceContext context;
    private DirNode fsTree;
    private final RamPath root;
    private RamPath pwd;
    private final String name;
    private Option<URLStreamHandler> urlStreamHandler;

    public static final ResourceContext init$default$3() {
        return RamFileSystem$.MODULE$.init$default$3();
    }

    public static final String init$default$2() {
        return RamFileSystem$.MODULE$.init$default$2();
    }

    public static final RamFsId init$default$1() {
        return RamFileSystem$.MODULE$.init$default$1();
    }

    public static final String apply$default$1() {
        return RamFileSystem$.MODULE$.apply$default$1();
    }

    public static final void scalax$file$ramfs$RamFileSystem$$register(RamFsId ramFsId, RamFileSystem ramFileSystem) {
        RamFileSystem$.MODULE$.scalax$file$ramfs$RamFileSystem$$register(ramFsId, ramFileSystem);
    }

    public static final String protocol() {
        return RamFileSystem$.MODULE$.protocol();
    }

    public RamFsId id() {
        return this.id;
    }

    @Override
    public String separator() {
        return this.separator;
    }

    @Override
    public ResourceContext context() {
        return this.context;
    }

    private DirNode fsTree() {
        return this.fsTree;
    }

    private void fsTree_$eq(DirNode dirNode) {
        this.fsTree = dirNode;
    }

    public RamPath root() {
        return this.root;
    }

    public RamPath pwd() {
        return this.pwd;
    }

    public void pwd_$eq(RamPath ramPath) {
        this.pwd = ramPath;
    }

    @Override
    public String name() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Option<URLStreamHandler> urlStreamHandler() {
        if ((this.bitmap$0 & 8) != 0) return this.urlStreamHandler;
        RamFileSystem ramFileSystem = this;
        synchronized (ramFileSystem) {
            if ((this.bitmap$0 & 8) == 0) {
                this.urlStreamHandler = new Some((Object)Handler$.MODULE$);
                this.bitmap$0 = this.bitmap$0 | 8;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.urlStreamHandler;
        }
    }

    @Override
    public RamPath fromString(String path) {
        return path.startsWith(this.separator()) ? this.fromStrings("", path) : this.fromStrings(this.pwd().toAbsolute().path(), path);
    }

    @Override
    public RamPath doCreateFromSeq(Seq<String> segments) {
        return this.fromString(segments.mkString(this.separator()));
    }

    public RamPath apply(String relativeTo, Seq<String> segments) {
        return this.fromStrings(relativeTo, ((TraversableOnce)segments.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String string) {
                return string.isEmpty();
            }
        })).mkString(this.separator()));
    }

    public RamPath fromStrings(String relativeTo, String path) {
        RamPath newpath;
        RamPath ramPath = newpath = new RamPath(this.process$1(relativeTo), this.process$1(path), this);
        RamPath ramPath2 = this.root();
        return !(ramPath != null ? !((Object)ramPath).equals(ramPath2) : ramPath2 != null) ? this.root() : newpath;
    }

    public Set<RamPath> roots() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RamPath[]{this.root()}));
    }

    @Override
    public RamFileSystem updateContext(ResourceContext newContext) {
        return new RamFileSystem(this.id(), this.separator(), newContext);
    }

    @Override
    public RamFileSystem updateContext(Function1<ResourceContext, ResourceContext> f) {
        return this.updateContext((ResourceContext)f.apply((Object)this.context()));
    }

    @Override
    public RamPath createTempFile(String prefix, String suffix, String dir, boolean deleteOnExit) {
        return (RamPath)this.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.separator(), "temp", UUID.randomUUID().toString()}));
    }

    @Override
    public RamPath createTempDirectory(String prefix, String suffix, String dir, boolean deleteOnExit) {
        return (RamPath)this.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.separator(), "temp", UUID.randomUUID().toString()}));
    }

    public URI uri(RamPath path) {
        return new URI(new StringBuilder().append((Object)RamFileSystem$.MODULE$.protocol()).append((Object)"://").append((Object)this.id().id()).append((Object)"!").append((Object)path.path().replaceAll("\\\\", "/")).toString());
    }

    public RamPath uri$default$1() {
        return this.root();
    }

    public String toString() {
        return "Ram File System";
    }

    public Option<Node> lookup(RamPath path) {
        Seq<String> absolutePath = path.toAbsolute().segments();
        return this.fsTree().lookup(absolutePath);
    }

    public boolean create(RamPath path, NodeFac fac, boolean createParents$1) {
        boolean bl;
        RamPath ramPath = path;
        RamPath ramPath2 = this.root();
        if (!(ramPath != null ? !((Object)ramPath).equals(ramPath2) : ramPath2 != null)) {
            bl = true;
        } else {
            Some some;
            RamPath ramPath3;
            RamPath p;
            RamPath absolute = path.toAbsolute();
            Option<RamPath> option = absolute.parent();
            if (option instanceof Some && this.gd2$1(p = (ramPath3 = (RamPath)(some = (Some)option).x()), createParents$1)) {
                throw new FileNotFoundException(new StringBuilder().append((Object)"Parent directory ").append((Object)p).append((Object)" does not exist").toString());
            }
            this.fsTree().create((Seq<String>)((Seq)absolute.segments().drop(1)), fac);
            bl = true;
        }
        return bl;
    }

    public boolean create$default$3() {
        return true;
    }

    @Override
    public boolean createTempDirectory$default$4() {
        return true;
    }

    @Override
    public String createTempDirectory$default$3() {
        return null;
    }

    @Override
    public String createTempDirectory$default$2() {
        return null;
    }

    @Override
    public String createTempDirectory$default$1() {
        return this.randomPrefix();
    }

    @Override
    public boolean createTempFile$default$4() {
        return true;
    }

    @Override
    public String createTempFile$default$3() {
        return null;
    }

    @Override
    public String createTempFile$default$2() {
        return null;
    }

    @Override
    public String createTempFile$default$1() {
        return this.randomPrefix();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean delete(RamPath path$1, boolean force$1) {
        if (!path$1.exists()) {
            return false;
        }
        if (this.delete$1(path$1, force$1)) {
            RamPath ramPath = path$1;
            RamPath ramPath2 = this.root();
            if (ramPath == null ? ramPath2 != null : !((Object)ramPath).equals(ramPath2)) {
                None$ none$;
                path$1.toAbsolute().parent();
                Option<RamPath> option = path$1.toAbsolute().parent();
                if (!option.isEmpty()) {
                    None$ none$2;
                    void $inlThis1;
                    Option<Node> option2 = ((RamPath)$inlThis1.get()).node();
                    if (!option2.isEmpty()) {
                        None$ none$3;
                        void $inlThis4;
                        Node node = (Node)$inlThis4.get();
                        Option<Node> option3 = path$1.node();
                        if (!option3.isEmpty()) {
                            void parentNode$11;
                            void $inlThis7;
                            Node node2 = (Node)$inlThis7.get();
                            ((DirNode)parentNode$11).children().$minus$eq((Object)node2);
                            none$3 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        } else {
                            none$3 = None$.MODULE$;
                        }
                        none$2 = (Option)none$3;
                    } else {
                        none$2 = None$.MODULE$;
                    }
                    none$ = (Option)none$2;
                } else {
                    none$ = None$.MODULE$;
                }
                None$ deletions = none$;
                boolean bl = deletions.isDefined();
                return bl;
            }
        }
        RamPath ramPath = path$1;
        RamPath ramPath3 = this.root();
        if (ramPath == null) {
            if (ramPath3 != null) {
                return false;
            }
        } else if (!((Object)ramPath).equals(ramPath3)) return false;
        this.fsTree_$eq(new DirNode(this.separator()));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean move(RamPath src, RamPath dest$1) {
        Option<RamPath> option;
        block8: {
            DirNode dirNode;
            block7: {
                block6: {
                    block5: {
                        RamPath ramPath = src;
                        RamPath ramPath2 = this.root();
                        if (!(ramPath != null ? !((Object)ramPath).equals(ramPath2) : ramPath2 != null)) {
                            throw new IOException("Root cannot be moved");
                        }
                        option = dest$1.parent();
                        if (!(option instanceof Some)) break block5;
                        Some some = (Some)option;
                        RamPath ramPath3 = (RamPath)some.x();
                        RamPath ramPath4 = this.root();
                        RamPath ramPath5 = ramPath3;
                        if (!(ramPath4 == null ? ramPath5 != null : !((Object)ramPath4).equals(ramPath5))) break block6;
                        RamPath parent = ramPath3;
                        this.create(parent, DirNode$.MODULE$, true);
                        dirNode = (DirNode)parent.node().get();
                        break block7;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<RamPath> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                }
                dirNode = this.fsTree();
            }
            DirNode parentNode$2 = dirNode;
            Option<Node> option3 = src.node();
            if (!option3.isEmpty()) {
                void $inlThis1;
                Node node = (Node)$inlThis1.get();
                node.name_$eq(dest$1.name());
                parentNode$2.children().$plus$eq((Object)node);
            }
            return this.delete(src, true);
        }
        throw new MatchError(option);
    }

    public void copyFile(RamPath src, FileNode srcNode$1, RamPath dest) {
        dest.fileSystem().create(dest, FileNode$.MODULE$, true);
        dest.node().collect(new PartialFunction(this, srcNode$1){
            public static final long serialVersionUID;
            public final FileNode srcNode$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Node node) {
                Node node2 = node;
                if (node2 instanceof FileNode) {
                    ((FileNode)node2).data_$eq(this.srcNode$1.data());
                    return;
                }
                throw new MatchError((Object)node2);
            }

            public final boolean isDefinedAt(Node node) {
                Node node2 = node;
                return node2 instanceof FileNode;
            }
            {
                this.srcNode$1 = fileNode;
                Function1.class.$init$((Function1)this);
                PartialFunction.class.$init$((PartialFunction)this);
            }
        });
    }

    private final String process$1(String path) {
        String p = path.replace(new StringBuilder().append((Object)this.separator()).append((Object)this.separator()).toString(), this.separator());
        return p.endsWith(this.separator()) && p.length() > 1 ? (String)Predef$.MODULE$.augmentString(p).drop(1) : p;
    }

    private final boolean gd2$1(RamPath ramPath, boolean bl) {
        return ramPath.nonExistent() && !bl;
    }

    private final boolean delete$1(Path p, boolean bl) {
        return bl || p.canWrite() && Option$.MODULE$.option2Iterable(p.parent()).forall((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Path path) {
                return path.canWrite();
            }
        });
    }

    public RamFileSystem(RamFsId id, String separator, ResourceContext context) {
        this.id = id;
        this.separator = separator;
        this.context = context;
        this.fsTree = new DirNode(separator);
        RamFileSystem$.MODULE$.scalax$file$ramfs$RamFileSystem$$register(id, this);
        this.root = new RamPath("", this.fsTree().name(), this);
        this.pwd = this.root();
        this.name = new StringBuilder().append((Object)"Ram (").append((Object)id).append((Object)")").toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RamFsId
    implements ScalaObject,
    Product,
    Serializable {
        private final String id;

        public String id() {
            return this.id;
        }

        public RamFsId copy(String id) {
            return new RamFsId(id);
        }

        public String copy$default$1() {
            return this.id();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof RamFsId)) return false;
            RamFsId ramFsId = (RamFsId)object2;
            String string = ramFsId.id();
            String id$1 = string;
            if (!this.gd1$1(id$1)) return false;
            boolean bl = ((RamFsId)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public String productPrefix() {
            return "RamFsId";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int n) {
            int n2 = n;
            if (n2 == 0) {
                return this.id();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
        }

        public boolean canEqual(Object object) {
            return object instanceof RamFsId;
        }

        private final boolean gd1$1(String string) {
            String string2 = string;
            String string3 = this.id();
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }

        public RamFsId(String id) {
            this.id = id;
            Product.class.$init$((Product)this);
        }
    }
}

