/*
 * Decompiled with CFR 0.152.
 */
package scalax.file.ramfs;

import java.net.URI;
import scala.Function1;
import scala.Option;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WeakHashMap;
import scala.collection.mutable.WeakHashMap$;
import scala.runtime.BoxesRunTime;
import scalax.file.ramfs.RamFileSystem;
import scalax.file.ramfs.RamFileSystem$RamFsId$;
import scalax.file.ramfs.RamPath;
import scalax.io.DefaultResourceContext$;
import scalax.io.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RamFileSystem$
implements ScalaObject {
    public static final RamFileSystem$ MODULE$;
    private final String protocol;
    private final WeakHashMap<RamFileSystem.RamFsId, RamFileSystem> fileSystems;

    static {
        new RamFileSystem$();
    }

    public String protocol() {
        return this.protocol;
    }

    private WeakHashMap<RamFileSystem.RamFsId, RamFileSystem> fileSystems() {
        return this.fileSystems;
    }

    public RamFileSystem apply(String separator) {
        String x$4 = separator;
        RamFileSystem.RamFsId x$5 = this.init$default$1();
        ResourceContext x$6 = this.init$default$3();
        return new RamFileSystem(x$5, x$4, x$6);
    }

    public RamFileSystem apply(RamFileSystem.RamFsId fsId$1) {
        RamFileSystem$ ramFileSystem$ = this;
        synchronized (ramFileSystem$) {
            Option $inlThis1 = this.fileSystems().get((Object)fsId$1);
            Object object = !$inlThis1.isEmpty() ? $inlThis1.get() : new RamFileSystem(fsId$1, "/", (ResourceContext)DefaultResourceContext$.MODULE$);
            // ** MonitorExit[this] (shouldn't be in output)
            return (RamFileSystem)object;
        }
    }

    public RamPath apply(URI uri$1) {
        String string = uri$1.toString();
        if (!new StringOps(string).contains((Object)BoxesRunTime.boxToCharacter((char)'!'))) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)new StringBuilder().append((Object)"Ramfile system URIs must be of form: ramfs://fsId!path, was: ").append((Object)uri$1).append((Object)" (did not contain a !)").toString()).toString());
        }
        if (!uri$1.getScheme().equalsIgnoreCase("ramfs")) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)new StringBuilder().append((Object)"Ramfile system URIs must start with ramfs, was: ").append((Object)uri$1).toString()).toString());
        }
        String string2 = uri$1.getAuthority();
        RamFileSystem.RamFsId id = new RamFileSystem.RamFsId((String)new StringOps(string2).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(char c) {
                return c != '!';
            }
        }));
        RamFileSystem fs = this.apply(id);
        String path = uri$1.getRawPath().replace("/", fs.separator());
        return fs.fromString(path);
    }

    public String apply$default$1() {
        return "/";
    }

    public final void scalax$file$ramfs$RamFileSystem$$register(RamFileSystem.RamFsId fsId, RamFileSystem fs) {
        RamFileSystem$ ramFileSystem$ = this;
        synchronized (ramFileSystem$) {
            this.fileSystems().update((Object)fsId, (Object)fs);
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    public ResourceContext init$default$3() {
        return DefaultResourceContext$.MODULE$;
    }

    public String init$default$2() {
        return "/";
    }

    public RamFileSystem.RamFsId init$default$1() {
        return new RamFileSystem.RamFsId(RamFileSystem$RamFsId$.MODULE$.apply$default$1());
    }

    private RamFileSystem$() {
        MODULE$ = this;
        this.protocol = "ramfs";
        this.fileSystems = (WeakHashMap)WeakHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

