/*
 * Decompiled with CFR 0.152.
 */
package scalax.file;

import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.combinator.Parsers$$tilde$;
import scala.util.parsing.combinator.Parsers$Error$;
import scala.util.parsing.combinator.Parsers$Failure$;
import scala.util.parsing.combinator.Parsers$NoSuccess$;
import scala.util.parsing.combinator.Parsers$Success$;
import scala.util.parsing.combinator.RegexParsers;
import scalax.file.FileSystem;
import scalax.file.GlobParser$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0001\u001d\u0011!b\u00127pEB\u000b'o]3s\u0015\t\u0019A!\u0001\u0003gS2,'\"A\u0003\u0002\rM\u001c\u0017\r\\1y\u0007\u0001\u0019B\u0001\u0001\u0005\u00119A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!AB(cU\u0016\u001cG\u000f\u0005\u0002\u001255\t!C\u0003\u0002\u0014)\u0005Q1m\\7cS:\fGo\u001c:\u000b\u0005U1\u0012a\u00029beNLgn\u001a\u0006\u0003/a\tA!\u001e;jY*\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c%\ta!+Z4fqB\u000b'o]3sgB\u0011QDH\u0007\u00021%\u0011q\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0003)1\u0017\u000e\\3TsN$X-\u001c\t\u0003G\u0011j\u0011AA\u0005\u0003K\t\u0011!BR5mKNK8\u000f^3n\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0011\u0011F\u000b\t\u0003G\u0001AQ!\t\u0014A\u0002\tBq\u0001\f\u0001C\u0002\u0013\u0005Q&A\u0004tC\u001a,7+\u001a9\u0016\u00039\u0002\"!C\u0018\n\u0005AR!AB*ue&tw\r\u0003\u00043\u0001\u0001\u0006IAL\u0001\tg\u00064WmU3qA!9A\u0007\u0001b\u0001\n\u0003i\u0013\u0001C9v_R,7+\u001a9\t\rY\u0002\u0001\u0015!\u0003/\u0003%\tXo\u001c;f'\u0016\u0004\b\u0005C\u00049\u0001\t\u0007I\u0011A\u0017\u0002\u000b9|7+\u001a9\t\ri\u0002\u0001\u0015!\u0003/\u0003\u0019qwnU3qA!9A\b\u0001b\u0001\n\u0003i\u0014A\u00033pk\ndWm\u0015;beV\ta\bE\u0002@\u0001\u0012k\u0011\u0001A\u0005\u0003\u0003\n\u0013a\u0001U1sg\u0016\u0014\u0018BA\"\u0013\u0005\u001d\u0001\u0016M]:feN\u0004\"!H#\n\u0005\u0019C\"aA!os\"1\u0001\n\u0001Q\u0001\ny\n1\u0002Z8vE2,7\u000b^1sA!9!\n\u0001b\u0001\n\u0003i\u0014\u0001B:uCJDa\u0001\u0014\u0001!\u0002\u0013q\u0014!B:uCJ\u0004\u0003b\u0002(\u0001\u0005\u0004%\t!P\u0001\tcV,7\u000f^5p]\"1\u0001\u000b\u0001Q\u0001\ny\n\u0011\"];fgRLwN\u001c\u0011\t\u000fI\u0003!\u0019!C\u0001'\u00061Qm]2ba\u0016,\u0012\u0001\u0016\t\u0004\u007f\u0001+\u0006C\u0001,Z\u001d\tir+\u0003\u0002Y1\u00051\u0001K]3eK\u001aL!\u0001\r.\u000b\u0005aC\u0002B\u0002/\u0001A\u0003%A+A\u0004fg\u000e\f\u0007/\u001a\u0011\t\u000fy\u0003!\u0019!C\u0001'\u0006a!/Z7pm\u0016,5oY1qK\"1\u0001\r\u0001Q\u0001\nQ\u000bQB]3n_Z,Wi]2ba\u0016\u0004\u0003b\u00022\u0001\u0005\u0004%\t!P\u0001\u0007G\"|\u0017nY3\t\r\u0011\u0004\u0001\u0015!\u0003?\u0003\u001d\u0019\u0007n\\5dK\u0002BqA\u001a\u0001C\u0002\u0013\u0005Q(A\u0003he>,\b\u000f\u0003\u0004i\u0001\u0001\u0006IAP\u0001\u0007OJ|W\u000f\u001d\u0011\t\u000f)\u0004!\u0019!C\u0001{\u0005)a/\u00197vK\"1A\u000e\u0001Q\u0001\ny\naA^1mk\u0016\u0004\u0003b\u00028\u0001\u0005\u0004%\t!P\u0001\bg\u0016<W.\u001a8u\u0011\u0019\u0001\b\u0001)A\u0005}\u0005A1/Z4nK:$\b\u0005C\u0004s\u0001\t\u0007I\u0011A\u001f\u0002\u0013M,\u0007/\u0019:bi>\u0014\bB\u0002;\u0001A\u0003%a(\u0001\u0006tKB\f'/\u0019;pe\u0002BqA\u001e\u0001C\u0002\u0013\u0005Q(\u0001\u0003s_>$\bB\u0002=\u0001A\u0003%a(A\u0003s_>$\b\u0005C\u0004{\u0001\t\u0007I\u0011A*\u0002\tA\fG\u000f\u001b\u0005\u0007y\u0002\u0001\u000b\u0011\u0002+\u0002\u000bA\fG\u000f\u001b\u0011\t\u000by\u0004A\u0011A@\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007U\u000b\t\u0001\u0003\u0004\u0002\u0004u\u0004\r!V\u0001\u0005O2|'\r")
public class GlobParser
implements RegexParsers,
ScalaObject {
    private final String safeSep;
    private final String quoteSep;
    private final String noSep;
    private final Parsers.Parser<Object> doubleStar;
    private final Parsers.Parser<Object> star;
    private final Parsers.Parser<Object> question;
    private final Parsers.Parser<String> escape;
    private final Parsers.Parser<String> removeEscape;
    private final Parsers.Parser<Object> choice;
    private final Parsers.Parser<Object> group;
    private final Parsers.Parser<Object> value;
    private final Parsers.Parser<Object> segment;
    private final Parsers.Parser<Object> separator;
    private final Parsers.Parser<Object> root;
    private final Parsers.Parser<String> path;
    private final Regex whiteSpace;
    private Parsers.NoSuccess lastNoSuccess;
    private volatile Parsers$Success$ Success$module;
    private volatile Parsers$NoSuccess$ NoSuccess$module;
    private volatile Parsers$Failure$ Failure$module;
    private volatile Parsers$Error$ Error$module;
    private volatile Parsers$$tilde$ $tilde$module;

    public String safeSep() {
        return this.safeSep;
    }

    public String quoteSep() {
        return this.quoteSep;
    }

    public String noSep() {
        return this.noSep;
    }

    public Parsers.Parser<Object> doubleStar() {
        return this.doubleStar;
    }

    public Parsers.Parser<Object> star() {
        return this.star;
    }

    public Parsers.Parser<Object> question() {
        return this.question;
    }

    public Parsers.Parser<String> escape() {
        return this.escape;
    }

    public Parsers.Parser<String> removeEscape() {
        return this.removeEscape;
    }

    public Parsers.Parser<Object> choice() {
        return this.choice;
    }

    public Parsers.Parser<Object> group() {
        return this.group;
    }

    public Parsers.Parser<Object> value() {
        return this.value;
    }

    public Parsers.Parser<Object> segment() {
        return this.segment;
    }

    public Parsers.Parser<Object> separator() {
        return this.separator;
    }

    public Parsers.Parser<Object> root() {
        return this.root;
    }

    public Parsers.Parser<String> path() {
        return this.path;
    }

    public String apply(String glob) {
        Parsers.ParseResult parseResult = this.parseAll(this.path(), glob);
        if (parseResult instanceof Parsers.Success) {
            return (String)((Parsers.Success)parseResult).result();
        }
        if (parseResult instanceof Parsers.Failure) {
            throw new RuntimeException(new StringBuilder().append((Object)"Failed to parse ").append((Object)glob).append((Object)" as a 'glob' pattern: ").append((Object)((Parsers.Failure)parseResult).msg()).toString());
        }
        if (parseResult instanceof Parsers.Error) {
            throw new RuntimeException(new StringBuilder().append((Object)"Error parsing ").append((Object)glob).append((Object)" as a 'glob' pattern: ").append((Object)((Parsers.Error)parseResult).msg()).toString());
        }
        throw new MatchError((Object)parseResult);
    }

    public GlobParser(FileSystem fileSystem) {
        Parsers.class.$init$((Parsers)this);
        RegexParsers.class.$init$((RegexParsers)this);
        String string = fileSystem.separator();
        this.safeSep = !(string != null ? !string.equals("\\") : "\\" != null) ? "\\\\" : fileSystem.separator();
        String string2 = fileSystem.separator();
        this.quoteSep = !(string2 != null ? !string2.equals("\\") : "\\" != null) ? "\\\\" : Pattern.quote(fileSystem.separator());
        this.noSep = new StringBuilder().append((Object)"[^").append((Object)this.safeSep()).append((Object)"]").toString();
        this.doubleStar = this.literal("**").$up$up((Function1)new $anonfun$1(this));
        this.star = this.literal("*").$up$up((Function1)new $anonfun$2(this));
        this.question = this.literal("?").$up$up((Function1)new $anonfun$3(this));
        this.escape = this.regex(Predef$.MODULE$.augmentString("\\\\.?").r());
        this.removeEscape = this.escape().$up$up((Function1)new $anonfun$4(this));
        this.choice = this.accept(BoxesRunTime.boxToCharacter((char)'{')).$tilde$greater((Function0)new $anonfun$5(this)).$less$tilde((Function0)new $anonfun$6(this)).$up$up((Function1)new $anonfun$7(this));
        this.group = this.accept(BoxesRunTime.boxToCharacter((char)'[')).$tilde$greater((Function0)new $anonfun$8(this)).$less$tilde((Function0)new $anonfun$9(this)).$up$up((Function1)new $anonfun$10(this));
        this.value = this.regex(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"[^*?/\\\\\\{\\}\\[\\]").append((Object)this.safeSep()).append((Object)"]+").toString()).r()).$up$up((Function1)new $anonfun$11(this));
        this.segment = this.rep((Function0)new $anonfun$12(this)).$up$up((Function1)new $anonfun$13(this)).$bar$bar$bar((Function0)new $anonfun$14(this));
        this.separator = this.regex(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"/|").append((Object)this.quoteSep()).toString()).r());
        this.root = this.regex(Predef$.MODULE$.augmentString(((TraversableOnce)fileSystem.roots().map((Function1)new $anonfun$15(this), Set$.MODULE$.canBuildFrom())).mkString("|")).r());
        this.path = this.opt((Function0)new $anonfun$16(this)).$tilde((Function0)new $anonfun$17(this)).$up$up((Function1)new $anonfun$18(this));
    }
}

